/*
 /*
 * Fsm.java
 *
 * Created on 24 febbraio 2007, 21.37
 *
 *  28-feb-2007: added variables: WebServiceID: int, Target: boolean, states: SortedSet; AdiacenceMatrix representation AdiacenceMatrix, 
 *                                  private method indexOfState(State s), getTransitions(): Set<Transition>
 * 
 *  02-mar-2007: JavaDoc, aggiornare i vecchi metodi che accedono alla collezione dei vertici della superclasse facendoli 
 *                  accedere alla nostra locale, vedere come gestire il campo id
 *
 *  19-mar-2007: added variable initialState
 * 
 *  01-nov-2007: added variable serviceName
 *
 *  TO DO: modify checkSingleInitialState using variable initialState
 */

package org.dis.uniroma1.swsce.fsm;

/**
 *
 * @author Valerio Colaianni
 */
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

import org.jgrapht.graph.DirectedMultigraph;

public class Fsm extends DirectedMultigraph<State,Transition> {
    
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	/**
     * The id of the Web Service in the comunity set by the Community object if it is a component one
     * or by the Composer one if it is the target.
     */
    private int id;
    
    /**
     * Indicates if this Fsm is a target service or a component one
     */
    private boolean target;
    
    /**
     * The set of the states of the Fsm (sorted by States)
     */
    private SortedSet<State> states;
    
    
    
    /**
     * The initial state of the Fsm
     */
    private State initialState;
    
    private String serviceName;
    
    /** Creates an empty instance of Fsm */
    public Fsm() {
        super(Transition.class);
        //System.out.println("ho invocato il costruttore della superclasse di FSM");
        id = -1;
        target = false;
        states = new TreeSet<State>();
        //System.out.println("ho costruito il treeSet di FSM");
        initialState = null;
        serviceName = null;
        //size = 0;
        //System.out.println("FINE COSTRUTTORE");
    }
    /** Creates a Fsm with a given id, specifying if it is a target or a component service */
    public Fsm(int id, boolean target) {
       super(Transition.class);
       this.id = id;
       this.target = target;
       states = new TreeSet<State>();
       initialState = null;
       serviceName = null;
       //size = 0;
    }
    
    public String getServiceName() {
        return this.serviceName;
    }
    
    public void setServiceName(String sn) {
        this.serviceName = sn;
    }
    
    public void assignStatesID() {
        int i = 0;
        this.initialState.setStateID(i++);
        for(State s: states) {
            Set<Transition> trans = this.outgoingTransitionOf(s);
            for(Transition t: trans) {
                State tar = t.getTarget();
                if(tar.getStateID() == -1)
                    tar.setStateID(i++);
            }
        }
        //System.out.print("StateSize="+states.size()+" nextID:"+i);
    }
    
    /** 
	 * Insert the transition in the FSM, if the states are not present in the FSM it first insert the states.
	 * @param t The transition
	 * @exception NotFSMException if there are more than 1 initial state
    */
    public void addTransition(Transition t) throws NotFSMException {
        State sr =t.getSource();
        State tg =t.getTarget();
        addState(sr);
        addState(tg);
        //addVertex(sr);
        //states.add(t.getSource());
        //addVertex(tg);
        //states.add(t.getTarget());
        
        if(!checkSingleInitialState())
            throw new NotFSMException("There are multiple initial states");
        //System.out.println("sto per eseguire addEdge(t) t= "+t.toString());
        addEdge(sr,tg,t);
    }
    
    /**
     * Add the specified state in the FSM
     * @param s The state
     * @exception NotFSMException if there are more than 1 initial state
     */
    public void addState(State s) throws NotFSMException {
        addVertex(s);
        //s.setStateID(size++);
        states.add(s);
        
        if(s.getDescription().equals(StateDescription.INITIAL_FINAL))
            this.initialState = s;
    }
    /**
     * check if there are isolate states
     * @return true if there are isolate states
     */
    public boolean checkIsolateStates() {
        
        boolean isolated = false;

        for(State s : states) {

                //State s = i.next();
                //System.out.println("sto processando: "+s);

                //Ottimizzabile
                if(inDegreeOf(s) == 0 && outDegreeOf(s) == 0) {
                        //System.out.println("ho trovato grado entrante = grado uscente = 0");
                        isolated = true;
                }


                Set<Transition> edges = incomingEdgesOf(s);
                //System.out.println("lista delle transizioni entranti:"+edges);
                for(Transition t : edges) {
                    //Transition t = edges.get(j);
                    if(t.getSource().equals(t.getTarget()))
                        isolated = true;
                    else {
                        isolated = false;
                        break;
                    }
                }

                edges = outgoingEdgesOf(s);
                //System.out.println("lista delle transizioni uscenti:"+edges);

                for(Transition t : edges) {
                    //Transition t = edges.get(j);
                    if(t.getSource().equals(t.getTarget()))
                            isolated = true;
                   else {
                        isolated = false;
                        break;
                    }
                }

                //System.out.println("--------------------------------------------------\n");

                if(isolated)
                        return true;

        }

        return isolated;

    }
    
    /**
     * @return a representation of the Fsm.
     */ 
    @Override public String toString() {
         
         String s = "";
         Set<Transition> transitions = this.edgeSet();
         s = "States: " + states.toString();
         s += "Transitions: " + transitions.toString();
         return s;
     }
    
    /**
     * @return the id of the Web Service in the comunity.
     */
    public int getId(){
        return id;
    }
    
    /**
     * @param id set the id of this service in the community
     */
    public void setId(int id) {
        this.id = id;
    }
    
    /**
     * return the initial state of the Fsm
     * @return the initial state of the Fsm
     */
    public State getInitialState() {
        
        return initialState;
    }
    
    /**
     * @return a copy of set of Transitions of the Fsm.
     */
    public Set<Transition> getTransitions() {
        return new HashSet<Transition>(edgeSet());
    }
    /**
     * @return a copy of the States of the Fsm.
     */
    public SortedSet<State> getStates() {
        return new TreeSet(states);
    }
   
    /**
     * @return the cardinality of the set of States
     */
    public int stateSize() {
        return states.size();
    }
    
    /**
     * @param s the source state
     * @param t the target state
     * @return the set of the Transition between the given states s and t
     */
    public Set<Transition> getTransitionsFromStates(State s, State t) {
        return getAllEdges(s,t);
    }
    
    /**
     * @param s the source state
     * @return the set of transition departing from state s
     */
    public Set<Transition> outgoingTransitionOf(State s) {
        return outgoingEdgesOf(s);
    }
    
    /**
     * @param s the source state
     * @param t the target state
     * @return one or the Transition between the given states s and t
     */
    public Transition getTransitionFromState(State s, State t) {
        return getEdge(s,t);
    }
    /**
     * @param i the index of the state
     * @return the state at a given index in our ordered set of states of the Fsm
     */
    public State getStateByIndex(int i) {
        State[] ss = new State[2];
        ss = states.toArray(ss);
        return ss[i];
    }
    
    //METODI AGGIUNTI FARE JAVA DOC
    
    
    public Set<State> getReachableStatesByAction(State s,String action) {
        
        HashSet<State> hs = new HashSet<State>();
        Set<Transition> trans = this.outgoingTransitionOf(s);
        for(Transition t : trans) {
            if(t.getAction().equals(action))
                hs.add(t.getTarget());
        }
        return hs;
    }
    
    public int getIndexByState(State s) {
        int i = 0;
        for(State ss: states) {
            if(ss.equals(s))
                return i;
            i++;
        }
        return -1;
    }
    
    public int getIndexByStateName(String s) {
        int i = 0;
        for(State ss: states) {
            if(ss.getName().equals(s))
                return i;
            i++;
        }
        return -1;
    }
    
    /**
     * @return true if this Web Service is a target one, otherwise returns false.
     */
    public boolean isTarget() {
        return target;
    }
    
    /**
     * @param isTarget specify if the given Fsm represents a target service or a component one
     */
    public void setTarget(boolean isTarget) {
        this.target = isTarget;
    }
    /**
     * The adiacence matrix is a representation of the Fsm. It is a n X n matrix where n is the cardinality of the
     * set of States, the element (i,j) is true iff exist one transition between i and j.
     * @ return the adiacence matrix.
     */ 
    public boolean[][] adiacenceMatrix() {
        
        
        boolean[][] matrix = new boolean[states.size()][states.size()];
        int i=0, j=0;
        for(State s : states) {
            
            //System.out.println(s);
            Set<Transition> stellaUsc = outgoingEdgesOf(s);
            
            for(Transition t: stellaUsc) {
                int pos = indexOfState(t.getTarget());
                matrix[i][pos] = true;
            }
            ++i;
        }
        
        return matrix;
    }
    
    /**
     * The nonTransition are the complement set of the Transitions set on the outgoing transitions originating from a given
     * state.
     * @param s the state from which the transitions depart
     * @return the other transion that not depart from the given state
     */  
    public Set<Transition> nonTransition(State s) {
        HashSet<Transition> hs = new HashSet<Transition>();
        Set<Transition> trans = edgeSet();
        Set<Transition> stellaUsc = outgoingEdgesOf(s);
        
        for(Transition t: trans)
            if(!stellaUsc.contains(t))
                hs.add(t);
        return hs;
    }
    
    /**
     * The final states are those states where a service can ends its computation
     * @return the set of final states for this fsm
     */
    public Set<State> getFinalStates() {
        Set<State> ss = new HashSet<State>();
        for(State s: states)
            if(s.getDescription().equals(StateDescription.FINAL) || s.getDescription().equals(StateDescription.INITIAL_FINAL))
                ss.add(s);
        return ss;
    }
    
    
    private int indexOfState(State s) {
        State[] ss = new State[2];
        ss = states.toArray(ss);
        int i = 0;
        for( ; i < ss.length ; i++){
            if(s.equals(ss[i]))
                return i;
        }
       //non si dovrebbe mai raggiungere se invocato da adiacenceMatrix()
       return -1;
    }
    
    /**
     * Check if exists a single initial state, a FSM cannot have multiple initial states
     */
    private boolean checkSingleInitialState() {

        boolean enconteredInitialState = false, ok = false;
        
        //Set<State> v = vertexSet();
        
        for(State s: states) {
            if(s.getDescription() == StateDescription.INITIAL_FINAL && !enconteredInitialState) {
                    enconteredInitialState = true;
                    ok = true;
                    //System.out.println("ho incontrato lo stato iniziale la prima volta ok=true");
            }
            else	

            if(s.getDescription() == StateDescription.INITIAL_FINAL && enconteredInitialState) {
                    ok = false;
                    //System.out.println("ho incontrato lo stato iniziale una seconda volta ok=false");
            }
        }
        return ok;	
    }
    
}
