package org.dis.uniroma1.swsce.composition;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

import org.dis.uniroma1.swsce.fsm.parser.FsmFileType;

public class TestComp {

	/**
	 * @param args
	 * @throws Exception
	 */
	public static void main(String[] args) throws Exception{
		int result = executeWSCE(args);
		if (result != 0)
			System.exit(result);
	}
	
	/**
	 * @param args
	 * @return
	 */
	public static int executeWSCE(String[] args) throws Exception {
		if ((args.length < 2) || (args[0].length() == 0) || (args[1].length() == 0)) {
			System.err.println("Parametri necessari: <path completo directory composizioni> <nome directory di lavoro> <command line>");
			System.err.println("\t<path completo directory composizioni> path directory Composizioni");
			System.err.println("\t<nome directory di lavoro> directory contenente wstsl");
			System.err.println("\t<command line> comando per eseguire processi esterni ('cmd.exe /c' per NT o 'bash' per Unix/GNU-Linux); pu essere ommesso");
			return 1;
		}

		//System.out.println("passati i controlli");
		SwsceSingleton.getInstance().setPathComposizioni(args[0]);
		String OG = args[1];
		if (args.length == 3)
			SwsceSingleton.getInstance().setCommandLine(args[2]);

		//String OG = "test1";
		System.out.println("********************************************************");
		System.out.println("Using path " + SwsceSingleton.getInstance().getPathComposizioni() + " with working directory " + OG);
		System.out.println("Initializing....");
		Community cm = new Community();

		File dir = new File(SwsceSingleton.getInstance().getPathComposizioni()+File.separator+OG+File.separator+"wstsl");
		System.out.println("Working dir: "+ OG);
		File[] wstsl = dir.listFiles(); 

		for(File f : wstsl) {

			if(!f.isDirectory())
				cm.addService(f,FsmFileType.WSTSL);
		}
		System.out.println("Community parsed.");

		Composer test = new Composer(cm,OG);

		//System.out.print("Sto leggendo il target...");
		File target = new File(SwsceSingleton.getInstance().getPathComposizioni()+File.separator+OG+File.separator+"wstsl"+File.separator+"target"+File.separator+OG+".wstsl");

		test.setTarget(target,FsmFileType.WSTSL);
		System.out.println("Target parsed.");
		//System.out.println(test);
		//System.out.println("sto scrivendo la base di conoscenza in TLV...");
		System.out.println("KB base written on file: " + OG + ".smv\r\n");
		test.setKBFile(OG+".smv");
		test.writeSMV_TLV_KB();
		System.out.println("********************************************************\r\n");
		System.out.print("Starting composition...");

		if(test.calculateComposition()) {
			System.out.println(" Specification is realizable! See composition.xml.");
			FileReader fr = new FileReader(SwsceSingleton.getInstance().getPathComposizioni()+File.separator+OG+File.separator+OG+".nor");
			BufferedReader br = new BufferedReader(fr);

			String s = br.readLine();

			while(!s.equals("State 1")) 
				s = br.readLine();

			System.out.println();

			while(s!=null) {
				System.out.println(s);
				s = br.readLine();
			}

			return 0;
		}
		else {
			System.err.println("Composition failed.");
			return 1;
		}
		//String url = CreateTarget.create(OG);
		//System.out.println("Ho finito");
		//*/
	}
}

