/*
 * Composer.java
 *
 * Created on 1 marzo 2007, 17.27
 *
 *  19-mar-2007: corretto il parser Fsm -> Krss KB
 */

package org.dis.uniroma1.swsce.composition;

/**
 *
 * @author Valerio Colaianni
 */

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Set;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.dis.uniroma1.swsce.fsm.Fsm;
import org.dis.uniroma1.swsce.fsm.MealyFsm;
import org.dis.uniroma1.swsce.fsm.MealyTransition;
import org.dis.uniroma1.swsce.fsm.State;
import org.dis.uniroma1.swsce.fsm.StateDescription;
import org.dis.uniroma1.swsce.fsm.Transition;
import org.dis.uniroma1.swsce.fsm.parser.FsmFileType;
import org.dis.uniroma1.swsce.fsm.parser.WSCDLParser;
import org.dis.uniroma1.swsce.fsm.parser.WSTSLParser;
import org.xml.sax.SAXException;

//import dis.wsce.dao.*;

//import dis.wsce.parser.*;

public class Composer {

	private Fsm target;
	private Community community;
	private String KBURL;
	private String KBFILE;
	private String URLCOMP;
	private String OG;
	/** Creates a new instance of Composer */
	public Composer(String OG) {
		KBURL = SwsceSingleton.getInstance().getPathComposizioni()+File.separator+OG+File.separator;
		URLCOMP = KBURL;
		this.OG = OG;
	}

	public Composer(Fsm target, String OG) {
		KBURL = SwsceSingleton.getInstance().getPathComposizioni()+File.separator+OG+File.separator;
		URLCOMP = KBURL;
		this.target = target;
		community = null;
		this.OG = OG;
	}

	public Composer(Community c, String OG) {
		KBURL = SwsceSingleton.getInstance().getPathComposizioni()+File.separator+OG+File.separator;
		URLCOMP = KBURL;
		this.community = c;
		target = null;
		this.OG = OG;
	}

	public Composer(Fsm target, Community c, String OG) {
		KBURL = SwsceSingleton.getInstance().getPathComposizioni()+File.separator+OG+File.separator;
		URLCOMP = KBURL;
		this.target = target;
		this.community = c;
		this.OG = OG;
	}

	public void setKBFile(String fileName) {
		this.KBFILE = fileName;

	}

	public Fsm getTarget() {
		return target;
	}

	public void setTarget(Fsm target) {
		target.setId(0);
		this.target = target;
		//System.out.println("il target e \' stato settato");
	}

	public void setTarget(File fsm,FsmFileType inputType) {
		SAXParserFactory parserFact = SAXParserFactory.newInstance();
		SAXParser parser = null;

		try {

			parser = parserFact.newSAXParser();

			if(inputType.equals(FsmFileType.WSCDL)) {

				WSCDLParser wp = new WSCDLParser();
				parser.parse(fsm,wp);
				Fsm s = wp.getFsm();
				s.setTarget(true);
				setTarget(s);
				//System.out.println("il target is "+s);
			}
			if(inputType.equals(FsmFileType.WSTSL)) {

				//passo il file da parsare in quante deve essere preparsato con un'altra istanza di SAX
				//per avere gli stati. Alternativa usare DOM ma sconveniente in termini di memoria
				//dato che con 2 passate il parsing  fatto!

				WSTSLParser wp = new WSTSLParser(fsm);
				parser.parse(fsm,wp);
				Fsm s = wp.getFsm();
				s.setTarget(true);
				setTarget(s);
			}
		} 
		catch (SAXException ex) {
			ex.printStackTrace();
		} 
		catch (ParserConfigurationException ex) {
			ex.printStackTrace();
		}
		catch(IOException ex) {
			ex.printStackTrace();
		}
	}

	public boolean calculateComposition() throws Exception{
		String perc = KBURL+KBFILE;
		perc = perc.substring(0,perc.length()-4);
		//System.out.println(perc);

		try {
			//System.out.println("creo runtime");
			Runtime rt = Runtime.getRuntime();
			//System.out.println("runtime creato, eseguo exec");
//			Process thePr = rt.exec("cmd /c tlv comp-inv.pf " + perc+".smv > " + perc+".txt");
			Process thePr = rt.exec(SwsceSingleton.getInstance().getCommandLine() + " tlv comp-inv.pf \"" + perc+".smv\" > \"" + perc+".txt\"");
			//System.out.println("exec riuscito, aspetto terminazione regolare");
			//thePr = rt.exec("cmd /c dir");
			OutputStream os = thePr.getOutputStream();
			os.close();
			if (thePr.waitFor() != 0) {
				System.err.println("exit value = " + thePr.exitValue());
			}
			//thePr.destroy();
			//int exitVal = thePr.exitValue();
			//System.out.println("Process exitValue: " + exitVal);
		}
		catch(Throwable t) {
			t.printStackTrace();
		}

		try {

			FileReader fr = new FileReader(perc + ".txt");
			BufferedReader br = new BufferedReader(fr);

			String s = br.readLine();

			while(s!=null) {
				if(s.trim().equals("Specification is unrealizable"))
					return false;
				s=br.readLine();
			}
		}
		catch(IOException e) {
			e.printStackTrace();
			//do something
		}
		/*
        File dir = new File(KBURL+"/wstsl");

        SAXParserFactory parserFact = SAXParserFactory.newInstance(); 
        try {
            SAXParser parser = parserFact.newSAXParser();
            for(Fsm fsm : this.community.getServices()) {
                File wsdl = new File("c:/composizioni/wsdl/"+fsm.getServiceName()+".wsdl");
                System.out.println(fsm.getServiceName());
                WSDLParser wp = new WSDLParser();
                parser.parse(wsdl,wp);
                System.out.println(wsdl.getAbsolutePath().length());

                DAOWsce.insertService(fsm.getServiceName(),wsdl.getAbsolutePath(),dir.getAbsolutePath()+fsm.getServiceName()+".wstsl",wp.getAddress(),false);

                DAOWsce.insertTS(fsm,fsm.getServiceName());

            }
        }
        catch(Exception ex) {ex.printStackTrace();}
        System.out.println("STO CHIAMANDO LA NORMALIZZAZIONE");
        normalizeOutput();

        File tar = new File(KBURL+"/wstsl/target/"+KBFILE.substring(0,KBFILE.length()-4)+".wstsl");
        System.out.println("TARGET: "+tar.getAbsolutePath());
        DAOWsce.insertService(KBFILE.substring(0,KBFILE.length()-4),"wsdl",tar.getAbsolutePath(),"jwsAddress",true);
        DAOWsce.insertTS(target,OG);
        DAOWsce.insertComposition(KBFILE.substring(0,KBFILE.length()-4), this.community, KBFILE.substring(0,KBFILE.length()-4), KBFILE.substring(0,KBFILE.length()-4) + ".nor");
		 */
		normalizeOutput();

		//try {
		MealyFsm compo = parseComposition();
		//}
		//catch(Exception e) {
		//System.out.println(e);
		//e.printStackTrace();
		//}
		writeXMLComposition(compo);
		createOGTableScript(OG,community.getSize());
		return true;
	}

	private void createOGTableScript(String OG, int n) {

		FileWriter fw = null;
		try {
			fw = new FileWriter(SwsceSingleton.getInstance().getPathComposizioni()+File.separator+OG+File.separator+"composition.sql");
		}
		catch(IOException e) {
			e.printStackTrace();
		}
		PrintWriter pw = new PrintWriter(fw,true);

		pw.println("DROP TABLE "+ OG +" cascade;");
		pw.println("DROP TABLE "+ OG +"_nextState cascade;");
		pw.println();
		//System.out.println("createOGTable("+OG+","+n+")");
		String sqlCreate = "CREATE TABLE " + OG + " (\r\n" +
		"\tSTATE varchar(10) primary key, \r\n" +
		"\tIN_ACT varchar(30) not null, \r\n"  +
		"\tTargetState VARCHAR(4) not null, \r\n" ;
		//query per creare tabella degli stati
		String sqlCreate2 = "CREATE TABLE " + OG +"_nextState(\r\n" +
		"\tSTATE_SOURCE varchar(20) references "+OG+"(STATE), \r\n" +
		"\tSTATE_TARGET varchar(20) references "+OG+"(STATE)\r\n" +
		");";




		for(int i = 1; i <= n; i++)
			sqlCreate += "\tState_S"+i + " VARCHAR(4) not null,\r\n";   

		sqlCreate += "\tOUT_ACT varchar(4) not null\r\n);";

		pw.println(sqlCreate+"\r\n");
		pw.println(sqlCreate2+"\r\n");
		//Connection conn = ConnectionManager.getConnection();


		String URLCOMP = SwsceSingleton.getInstance().getPathComposizioni()+File.separator+OG+File.separator;

		try {
			//Statement stmt = conn.createStatement();
			String insertSql = "INSERT INTO " + OG + " values (";
			FileReader fr = new FileReader(URLCOMP + OG +".nor");
			BufferedReader br = new BufferedReader(fr);

			String s = br.readLine();

			int k = 1;
			String[] componenti = new String[n+4];
			int z = 0;

			while(!s.equals("State 1")) 
				s = br.readLine();

			while(!s.equals("")) {

				z = 0;
				//System.out.println(s);
				s = br.readLine();

				while(!s.equals("")) {

					s = s.trim();
					String[] linea = s.split(",");
					for(int i = 0; i < linea.length; i++)
						if(!linea[i].trim().equals("")) {
							//System.out.println(linea[i].trim() + " in z=" + z);
							//if(z>0 && z<5) {
							String[] st = linea[i].trim().split("=");
							//System.out.println(st[1].trim());
							componenti[z++] = st[1].trim();

							//}
							//else
							//  System.out.println("ramo morto?");
							// componenti[z++] = linea[i].trim();
						}

					s = br.readLine();
					s = s.trim();
				}
				String sql = insertSql + "'State"+k+"'";
				k++;

				for(int y=0; y < n+3 ; y++)
					sql += "," + "'" + componenti[y] + "'";
				sql += ")";
				//System.out.println(sql);

				//stmt.executeUpdate(sql);
				pw.println(sql+";");
				s = br.readLine();
				s = s.trim();
			}

			s = br.readLine();
			s = s.trim();
			//System.out.println(s);

			s = br.readLine();
			s = br.readLine();        
			// parsing per inserire tuple in OGNextState
			pw.println();
			while(!s.equals("")) {

				String[] linea = s.split(" ");

				String source = linea[1].trim();
				String target = linea[4].trim();

				String sqlInsert = "insert into "+ OG +"_nextState values('State" + source + "','State" + target + "');";

				pw.println(sqlInsert);

				for(int i = 5; i < linea.length; i++) {
					//System.out.println("componente i=" + i +" " + linea[i].trim());
					target = linea[i].trim();
					sqlInsert = "insert into "+ OG +"_nextState values('State" + source + "','State" + target + "');";
					pw.println(sqlInsert);
				}

				s = br.readLine();
			}


		}
		catch(IOException e) {
			e.printStackTrace();
		}
		pw.close();
	}


	private void writeXMLComposition(MealyFsm m) throws Exception{

		FileWriter fw = new FileWriter(SwsceSingleton.getInstance().getPathComposizioni()+File.separator+OG+File.separator+"composition.xml");
		PrintWriter pw = new PrintWriter(fw,true);

		pw.println("<TS>");

		Set<State> states = m.getStates();

		//System.out.println(m);



		for(State s : states) {
			//System.out.println(s);
			pw.println("\t<STATE name=\"" + s.getName()+"\">");
			Set<Transition> transitions = m.outgoingTransitionOf(s);

			//System.out.println(transitions);

			for(Transition trans : transitions) {
				MealyTransition t = (MealyTransition)trans;
				//System.out.println(t);
				State target = t.getTarget();
				pw.println("\t\t<TRANSITION action=\"" + t.getAction() +"\">");
				for(State _s : m.getReachableStatesByAction(s, t.getAction())) {
					pw.println("\t\t\t<TARGET state=\"" + _s.getName() + "\" service=\"" + t.getService() +"\"/>");

				}
				pw.println("\t\t</TRANSITION>");

			}
			pw.println("\t</STATE>");
		}
		pw.println("</TS>");

	}


	private MealyFsm parseComposition() throws Exception{

		File normalized = new File(KBURL+KBFILE.substring(0,KBFILE.length()-4) + ".nor");
		FileReader fr = new FileReader(normalized);
		BufferedReader br = new BufferedReader(fr);
		//System.out.println("valore di normalized: " + normalized.getAbsolutePath());


		MealyFsm compo = new MealyFsm();
		Hashtable<String,String[]> db = new Hashtable<String,String[]>();
		String[] tupla = new String[3+ community.size()];

		String s = br.readLine();
		//System.out.println("valore di s: " + s);

		int k = 1;
		int n = community.getSize();
		String[] componenti = new String[n+4];
		int z = 0;

		while(!s.equals("State 1")) 
			s = br.readLine();

		while(!s.equals("")) {
			tupla = new String[3+ community.size()];
			z = 0;
			//System.out.println(s);
			s = br.readLine();

			while(!s.equals("")) {

				s = s.trim();
				String[] linea = s.split(",");
				for(int i = 0; i < linea.length; i++)
					if(!linea[i].trim().equals("")) {
						//System.out.println(linea[i].trim() + " in z=" + z);
						//if(z>0 && z<5) {
						String[] st = linea[i].trim().split("=");
						//System.out.println(st[1].trim());
						componenti[z++] = st[1].trim();

						//}
						//else
						//  System.out.println("ramo morto?");
						// componenti[z++] = linea[i].trim();
					}

				s = br.readLine();
				s = s.trim();
			}
			//String sql = insertSql + "'State"+k+"'";

			for(int y=0; y < n+3 ; y++)
				tupla[y] = componenti[y];

			//System.out.println(sql);
			//stmt.executeUpdate(sql);
			db.put("State"+k, tupla);
			s = br.readLine();
			s = s.trim();
			k++;
		}

		s = br.readLine();
		s = s.trim();
		//System.out.println(s);

		s = br.readLine();
		s = br.readLine(); 

		State ss,tt;

		while(!s.equals("")) {

			String[] linea = s.split(" ");

			String source = linea[1].trim();
			if(!source.equals("1"))
				ss = new State(source,StateDescription.TRANSIENT);
			else
				ss = new State(source,StateDescription.INITIAL_FINAL);

			String target = linea[4].trim();
			tt = new State(target,StateDescription.TRANSIENT);

			MealyTransition t = new MealyTransition(db.get("State"+target)[0],
					ss,tt,
					Integer.parseInt(db.get("State"+target)[tupla.length-1]));
			//System.out.println("INSERISCO TRANS: "+t);
			compo.addTransition(t);


			for(int i = 5; i < linea.length; i++) {
				//System.out.println("componente i=" + i +" " + linea[i].trim());
				target = linea[i].trim();
				tt = new State(target,StateDescription.TRANSIENT);

				t = new MealyTransition(db.get("State"+target)[0],ss,tt,Integer.parseInt(db.get("State"+target)[tupla.length-1]));
				compo.addTransition(t);
			}

			s = br.readLine();
		}
		return compo;
	}

	private void normalizeOutput() {
		System.out.println("sto normalizzando l'output di TLV");
		File to_normalize = new File(KBURL+KBFILE.substring(0,KBFILE.length()-4) + ".txt");
		System.out.println("perc: "+KBFILE);
		System.out.println("FILE DA NORMALIZZARE: "+to_normalize.getAbsolutePath());
		File normalized = new File(KBURL+KBFILE.substring(0,KBFILE.length()-4) + ".nor");

		try {
			FileReader fr = new FileReader(to_normalize);
			FileWriter fw = new FileWriter(normalized);

			BufferedReader br = new BufferedReader(fr);
			PrintWriter pw = new PrintWriter(fw,true);

			String temp = br.readLine();
			int j = 1;
			while(temp!=null) {
				if(temp.startsWith("State"))
					j = 1;
				String daScrivere = "";
				if(temp.startsWith("In")) {
					String[] componenti = temp.split(",");
					//pw.println("componenti:");
					//for(int i = 0; i < componenti.length; i++) {
					//    pw.println(componenti[i].trim());
					//}
					for(int i = 0; i < componenti.length; i++) {
						componenti[i] = componenti[i].trim();
						if(componenti[i].startsWith("In.S")) {
							//pw.println("token: "+componenti[i]);

							temp = componenti[i].substring(4);
							//pw.println("temp:" +temp);
							//
							System.out.println(temp.substring(0,1));
							if(Integer.parseInt(temp.substring(0,1))!= j) {
								daScrivere += "In.S"+j+" = 0, ";
								daScrivere += componenti[i]+", ";
								j++;
							}
							else
								daScrivere += componenti[i]+", ";
							j++;
							System.out.println("ho incrementato j! j="+j);
						}

						if(componenti[i].startsWith("In.action"))
							daScrivere += componenti[i]+", ";
						if(componenti[i].startsWith("In.T"))
							daScrivere += componenti[i]+", ";
						if(componenti[i].startsWith("Out"))
							daScrivere += componenti[i]+", ";
						//System.out.println(daScrivere);
					}

				}
				else
					daScrivere += temp;
				pw.println(daScrivere);
				temp = br.readLine();
			}
			br.close();
			pw.close();
			System.out.println("ho chiuso gli stream");
		}
		catch(IOException ex) {
			ex.printStackTrace();
		}

	}

	private Set<String> getAllActions() {

		HashSet<String> hs = new HashSet<String>();

		for(Transition t: target.getTransitions())
			hs.add(t.getAction());

		for(Fsm fsm: community.getServices())
			for(Transition t: fsm.getTransitions())
				hs.add(t.getAction());

		return hs;
	}


	public void writeSMV_TLV_KB() {

		if(target != null && community != null) {

			//System.out.println("------------------------");
			//System.out.println("Stato iniziale:"+target.getInitialState()+ " " +"Stato con indice 0:" +target.getStateByIndex(0));

//			target.assignStatesID();
			try {

				PrintWriter pw = new PrintWriter(new FileOutputStream(KBURL + KBFILE),true);
				//System.out.println(KBURL+KBFILE);
				pw.println("-- KBFILE: "+KBFILE);

				//MODULE MAIN
				pw.println("MODULE main");
				pw.println("VAR");
				pw.println("\tIn:  system Input(Out.index);");
				pw.println("\tOut: system Output;");
				pw.println("DEFINE");
				pw.println("\tgood := !In.failure;");

				pw.println();

				//MODULE OUTPUT
				pw.println("MODULE Output");
				pw.println("VAR");
				pw.println("\tindex : 0.."+community.getSize()+";");
				pw.println("ASSIGN");
				pw.println("\tinit(index) := 0;");
				pw.println("\tnext(index) := 1.."+community.getSize()+";");

				pw.println();

				//MODULE INPUT
				pw.println("MODULE Input(index)");
				pw.println("VAR");

				//Actions of the Community
				String acts = "{nil";
				for(String s: community.getActions())
					acts += "," + s ;
				acts += "};";

				pw.println("\taction  : "+acts);
				pw.println("\tT1 : mT1(action);");

				String servicesFailure = "(";
				String _final = "(T1.final -> (";
				for(int i=1; i<=community.size(); i++) {

					pw.println("\tS" + i + " : mS" + i +"(index,action);");

					if(i<community.size()) {
						servicesFailure += "S"+i +".failure | ";
						_final +="S"+i +".final & ";
					}
					else {
						servicesFailure += "S"+i +".failure)";
						_final +="S"+i +".final))";
					}
				}
				pw.println("DEFINE");
				pw.println("\t failure:= "+ servicesFailure + " | !"+_final+";");

				pw.println();

				//TARGET
				pw.println("MODULE mT1(act)");
				pw.println("VAR");
				pw.println( "\tloc : 0.."+(target.stateSize()-1)+";");
				pw.println("ASSIGN");
				pw.println("\tinit(loc) := 0;");
				pw.println("\tinit(act) := nil;");
				pw.println("\tnext(loc) :=");
				pw.println("\tcase");
				pw.println();
				for(int i = 0; i < target.stateSize();i++) {
					String _state = "loc = " + i;
					State thisState = target.getStateByIndex(i);

					// MODIFICATO: AGGIUNGE I LOOP SUGLI STATI FINALI CON AZIONE CONSENTITA NIL
					if(thisState.getDescription().equals(StateDescription.FINAL))
						pw.println("\t\t" + _state + " & act = nil : " + i +";");

					for(Transition t: target.outgoingTransitionOf(thisState)) {
						String _act = "act = " + t.getAction(); 
						pw.println("\t\t" + _state + " & " + _act + ": " + target.getIndexByState(t.getTarget()) + ";");
					}
				}
				pw.println();
				pw.println("\t\tTRUE: loc;");
				pw.println( "\tesac;");
				pw.println();
				pw.println("\tnext(act) :=");
				pw.println("\tcase");

				Set<Transition> _st = target.outgoingTransitionOf(target.getInitialState());
				int id = target.getIndexByState(target.getInitialState());
				String temp = "loc = " + id + " & act = nil : {";
				for(Transition t: _st) {
					temp += t.getAction()+",";
				}
				temp = temp.substring(0,temp.length()-1);
				temp += "};";
				pw.println("\t\t"+temp);

				//loc = 0 & act = nil : {visualizzaMenu,visualizzaDrink};           


				for(int i=0; i < target.stateSize(); i++) {
					//System.out.println(target.getStateByIndex(i));
					for(Transition t: target.outgoingTransitionOf(target.getStateByIndex(i))) {

						String _temp = "loc = " + i + " & act = "+ t.getAction() +" : ";
						//loc = 0	& act = search  :

						String _acts = " {";
						//loc = 0	& act = search  : {

						State st = t.getTarget();
						Set<Transition> s_t = target.outgoingTransitionOf(st);

						for(Transition _t : s_t) {

							_acts +=_t.getAction() + ",";

						}
						_acts = _acts.substring(0,_acts.length()-1);
						_acts += "};";
						if(!s_t.isEmpty()) 
							pw.println("\t\t" + _temp + _acts);
					}

				}
				//MODIFICATO: Aggiunto su indicazione di fabio
				//(loc = 1 | loc = 2 | loc = 3 | loc = 4) : {nil};
				String orLoc = "(";
				for(State _s : target.getStates())
					if(!_s.getDescription().equals(StateDescription.INITIAL_FINAL))
						orLoc += "loc = " + target.getIndexByState(_s) + " | ";
				orLoc = orLoc.substring(0,orLoc.length()-2);
				orLoc += ") : {nil};";
				pw.println("\t\t" + orLoc);
				pw.println("\t\tTRUE : {act};");
				pw.println("\tesac;");

				pw.println("DEFINE");

				String _f = "final := (";

				Set<State> _fin = target.getFinalStates();
				for(State s: _fin)
					_f += " loc = " + target.getIndexByState(s) +"|";
				_f = _f.substring(0,_f.length()-1);
				_f +=");";


				pw.println("\t" + _f);

				//AVAILABLE
				for(Fsm fsm : community.getServices()) {
					pw.println("MODULE mS"+ fsm.getId()+"(index,action)");
					pw.println("DEFINE");   
					pw.println("VAR");    
					pw.println( "\tloc : 0.."+(fsm.stateSize()-1)+";");
					pw.println("ASSIGN");
					pw.println("\tinit(loc) := 0;");
					pw.println("\tnext(loc) :=");
					pw.println("\tcase");
					pw.println("\t\tindex !="+ fsm.getId()+" : loc;");
					LinkedList<String> hs = new LinkedList<String>();
					for(int i = 0; i < fsm.stateSize();i++) {
						String _state = "loc = " + i;

						State thisState = fsm.getStateByIndex(i);

						//MODIFICATO: Aggiunti loop su stati finali
						if(thisState.getDescription().equals(StateDescription.FINAL)) {
							pw.println("\t\t" + _state + " & action = nil : {" + i+"};");
							hs.add(_state + " & action in {nil}");
						}

						for(Transition t: fsm.outgoingTransitionOf(thisState)) {
							String _act = "action in {" + t.getAction() +"}";
							String _temp = "{";
							for(State _s: fsm.getReachableStatesByAction(thisState,t.getAction()))
								_temp += fsm.getIndexByState(_s)+",";
							_temp = _temp.substring(0,_temp.length()-1);
							_temp += "}";
							pw.println("\t\t" + _state + " & " + _act + ":" + _temp + ";");
							hs.add(_state + " & " + _act);
						}

					}
					pw.println("TRUE : loc;");
					pw.println("esac;");
					pw.println("DEFINE");
					String f = "failure := index = " + fsm.getId() + " & !(";
					//1 & !((loc = 0 & action in {search} )|(loc = 1 & action in {display, return}));
					for(String s: hs) {
						f += "(" + s + ")|";
					}
					f = f.substring(0,f.length()-1);
					f += ");";
					pw.println(f);

					_f = "final := (";

					_fin = fsm.getFinalStates();
					for(State s: _fin)
						_f += " loc = " + fsm.getIndexByState(s) +"|";
					_f = _f.substring(0,_f.length()-1);
					_f +=");";
					pw.println("\t" + _f);
					pw.println();
				}

				pw.close();

			}
			catch(IOException e) {

			}
		}
	}
	public static void main(String[] arg) {
		Composer c = new Composer("Test9");
		c.normalizeOutput();
	}  

}
