/*
 * Community.java
 *
 * Created on 1 marzo 2007, 16.45
 *
 * 
 */

package org.dis.uniroma1.swsce.composition;

/**
 *
 * @author Valerio Colaianni
 */

import org.dis.uniroma1.swsce.fsm.*;
import org.dis.uniroma1.swsce.fsm.parser.*;

import java.io.*;
import java.util.*;
import javax.xml.parsers.*;

import org.xml.sax.*;


public class Community {
    
    private String name;
    private Map<Integer,Fsm> services;
    private int size = 0;
    private Set<String> actions;
    
    /** Creates an empty Community of Web Services*/
    public Community() {
        name = null;
        services = new Hashtable<Integer,Fsm>();
        actions = new HashSet<String>();
    }
    
    /** Creates a Community with a given name
     * @param name the name of the community
     */
    public Community(String name) {
        this.name = name;
        services = new Hashtable<Integer,Fsm>();
        actions = new HashSet<String>();
    }
   
    public String getName() {
        return name;
    }
    
    public int size() {
        return size;
    }
    
    
    public Collection<Fsm> getServices() {
        // vedere se values torna una copia oppure no
        return services.values();
    }
    
    public void setName(String name) {
        this.name = name;
    }
    
    public Set<String> getActions() {
        return new HashSet<String>(actions);
    }
    
    public int getSize() {
        return this.size();
    }
    
    public void addService(Fsm eservice) {
        
        eservice.setId(++size);
        services.put(size,eservice);
        insertActions(eservice);
        //System.out.println("Sto inserendo nella community: "+eservice+"con id: "+eservice.getId());
        //System.out.println("e stati finali:" + eservice.getFinalStates());
    }
    
    public Set<String> getNonTransition(int id, State s) {
        Fsm service = services.get(id);
        return getNonTransition(service,s);
    }
    
    public Set<String> getNonTransition(Fsm service, State s) {
        Set<String> nonTrans = getActions();
        Set<Transition> servTrans = service.outgoingTransitionOf(s);
        for(Transition t: servTrans)
            nonTrans.remove(t.getAction());
        return nonTrans;
    }
    
    // si potrebbe fare anche un metodo che legge invece che un file un array di stringhe 
    // rappresentate il wscdl o il particolare fileType
    
    
    public void addService(File fsm, FsmFileType inputType)   {
        //System.out.println("inizio invocazione Community.addService");
        //Si deve istanziare un oggetto della classe SAXParserFactory
        SAXParserFactory parserFact = SAXParserFactory.newInstance();
        //System.out.println("SAXParserFactory.newInstance();... OK");
        SAXParser parser = null;
        
        try {
          
            parser = parserFact.newSAXParser();
           //System.out.println("parserFact.newSAXParser();... OK");
            if(inputType.equals(FsmFileType.WSCDL)) {
           
                WSCDLParser wp = new WSCDLParser();
                parser.parse(fsm,wp);
                Fsm s = wp.getFsm();
                s.setTarget(false);
                
                addService(s);
            }
            if(inputType.equals(FsmFileType.WSTSL)) {
                
                //passo il file da parsare in quante deve essere preparsato con un'altra istanza di SAX
                //per avere gli stati. Alternativa usare DOM ma sconveniente in termini di memoria
                //dato che con 2 passate il parsing  fatto!
                //System.out.println("sto per creare l'istanza di WSTSL Parser");
                WSTSLParser wp = new WSTSLParser(fsm);
                //System.out.println("creata istanza WSTSLPARSER");
                parser.parse(fsm,wp);
                //System.out.println("Parsato il file");
                Fsm s = wp.getFsm();
                s.setTarget(false);
                
                addService(s);
            }
        } 
        catch (SAXException ex) {
            ex.printStackTrace();
        } 
        catch (ParserConfigurationException ex) {
            ex.printStackTrace();
        }
        catch(IOException ex) {
            ex.printStackTrace();
        }
           
    }
    
        //inserisce le azioni atomiche all'interno della community
        private void insertActions(Fsm service) {
            for(Transition t: service.getTransitions())
                actions.add(t.getAction());
        }
    }
    
      
    
    
    
    
    
    
    
    
    
    

