package orchestrator;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedList;
import dao.ConnectionManager;

public class OrchestratorDAO {
	
    public static void storeOGTableDB(String fileName) throws SQLException, IOException{
    	Connection con = null;
        Statement st= null;
        ResultSet rs = null;
        try{
            String sql = readFile(fileName);
            String[] query = sql.split(";");
            con = ConnectionManager.getConnection();
            con.setTransactionIsolation(Connection.TRANSACTION_SERIALIZABLE);
            st=con.createStatement();
            for(int i= 0; i<query.length-1; i++){
                try{
                    st.executeUpdate(query[i]);
                }//la drop table fallisce se non esiste la tabella, devo solo andare avanti con lo script
                catch(com.mysql.jdbc.exceptions.MySQLSyntaxErrorException ex){
                }
            }
            if(st!=null)
                    st.close();
            con.commit();
            con.close();

        }catch(SQLException ex){
            ex.printStackTrace();
            if(con != null){
                con.rollback();
                con.close();
            }
            throw ex;
        }
        catch(IOException ex){
            ex.printStackTrace();
            throw ex;
        }
    }
	
	private final static String SEL_COLUMN = "SELECT COLUMN_NAME FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = ? ORDER BY ORDINAL_POSITION";

	
	public static int searchNextService(String op, int tstate, int[] states, String table) throws SQLException{
    	Connection con = null;
		PreparedStatement ps=null;
		ResultSet rs = null;
		Statement st = null;
		int outAct = -1;
		try{
			con = ConnectionManager.getConnection();
			ps =con.prepareStatement(SEL_COLUMN);
			ps.setString(1,table);
			rs = ps.executeQuery();
			LinkedList<String> columns = new LinkedList<String>();
			while(rs.next()){
				columns.add(rs.getString(1));
			}
			String searchNext = "SELECT OUT_ACT FROM "+table+" WHERE ";
			String in_act = columns.get(1);
			searchNext += in_act+" = '"+op+"' AND ";
			String targetstate = columns.get(2); //nome colonna targetstate: TargetState
			searchNext += targetstate+" = '"+tstate+"' ";
			for(int i = 3; i< columns.size()-1; i++){
				String statecolumns = columns.get(i);
				searchNext += " AND "+statecolumns+" = '"+states[i-3]+"' ";
			}
			st = con.createStatement();
			rs = st.executeQuery(searchNext);
			if(rs.next()){
				outAct = rs.getInt(1);
			}
			if(st!=null)
				st.close();
			if(ps!=null)
				ps.close();	
			con.close();
			
		}catch(SQLException ex){
			ex.printStackTrace();
			con.rollback();
			con.close();
			throw ex;
		}
		return outAct-1;
	}
	
 	private static String readFile (String fileName) throws IOException{
    
	    InputStreamReader isr = null;
	    StringBuffer sb = new StringBuffer ();
	    char[] buf = new char[1024];
	    int len;
	
	    try
	    {
	        FileInputStream fis = new FileInputStream (fileName);
	        isr = new InputStreamReader (fis);
	
	        while ((len = isr.read (buf)) > 0)
	            sb.append (buf, 0, len);
	
	        return sb.toString ();
	    }
	    finally
	    {
	        if (isr != null)
	            isr.close ();
	    }
}

	public static int getInitialTargetState(String table) throws SQLException{
		Connection con = null;
		Statement st = null;
		ResultSet rs =null;
		int target = -1;
		try{
			con = ConnectionManager.getConnection();
			st = con.createStatement();
			rs = st.executeQuery("SELECT targetstate FROM `"+table+"` where state = 'state1';");
			if(rs.next())
				target = rs.getInt(1);
			st.close();
			con.close();
		}
		catch(SQLException ex){
			ex.printStackTrace();
			con.rollback();
			con.close();
			throw ex;
		}
		return target;
		
	}
	
	
    public static int getTargetState(int state, String action,String table) throws Exception{
		
		Connection con = null;
		Statement st = null;
		ResultSet rs =null;
		int target = -1;
		try{
			con = ConnectionManager.getConnection();
			st = con.createStatement();
			String query = "SELECT distinct temp.targetfinale FROM " +
				"( SELECT t1.targetstate as targetIniziale ,t1.in_act , t2.targetstate as targetFinale " +
				" FROM `"+table+"` t1, "+table+" t2, "+table+"_nextstate where t1.state = state_source  and  state_target = t2.state ) temp " +
 				" where temp.in_act = '"+action+"' and temp.targetIniziale = "+state+"; ";
			rs = st.executeQuery(query);
			if(rs.next())
				target = rs.getInt(1);
			st.close();
			con.close();
			
		}
		catch(SQLException ex){
			ex.printStackTrace();
			con.rollback();
			con.close();
			throw ex;
		}
		return target;
		
	}
    
}