package orchestrator;

import java.net.*;
import java.rmi.*;

import javax.xml.namespace.*;
import javax.xml.rpc.*;
import org.apache.axis.client.Service;
import org.apache.axis.client.Call;
import java.sql.SQLException;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;

public class Orchestrator {
	
	private AvailableService[] services;
	private String tablename;
	private int targetstate ;
        private String id;
    
    public Orchestrator(ServiceInfo[] si, String table) throws ServiceException, SQLException, IOException{
         //Table name of the Orchestrator Generator
        System.out.println("\n********** ORCHESTRATOR INSTANCE INITIALIZATION **********\n");
        id = this.toString();
        System.out.println("orchestrator identifier: "+id);
    	tablename = table;
        System.out.println("tablename: "+table);
        targetstate = OrchestratorDAO.getInitialTargetState(table);
        System.out.println("target initial state: "+targetstate);
        //Create connection with all community services
    	services = new AvailableService[si.length];
    	for(int i=0; i<services.length; i++){
            Call call = (Call) new Service().createCall();
            call.setTargetEndpointAddress(si[i].getAddress());
            call.setMaintainSession(true);
            call.setTimeout(-1);
            AvailableService as = new AvailableService(si[i],call);
            services[i] = as;
            System.out.println("Connected to service "+(i+1)+": "+as.getInfo().getName());
    	} 
    }
    
    @SuppressWarnings("unchecked")
	public Orchestrator(ServiceInfo[] si, String table, LinkedList<Class> ComplexTypes) throws ServiceException, SQLException, IOException{
        this(si, table);
        //register all complextype mappings with all services
        if(ComplexTypes!= null){
            Iterator<Class> it = ComplexTypes.iterator();
            while(it.hasNext()){
                Class c = it.next();
                System.out.println("\tRegistering ComplexType class: "+c.getName());
                String fullclassname = c.getName();//nome della classe con anche il package
                String[] classnameparts = fullclassname.split("\\.");
                String classname = classnameparts[classnameparts.length-1];//nome della classe
                for(int i=0; i<services.length; i++){
                    AvailableService as = services[i];
                    String servicename = as.getInfo().getName();
                    QName q = new QName(servicename,classname);
                    Call call = as.getCall();
                    call.registerTypeMapping(c, q, BeanSerializerFactory.class, BeanDeserializerFactory.class);
                }
            }
        }
    }
    
    //L'indice dei servizi nell'array parte da 0, mentre gli indici nella tabella dell'OG partono da 1 quindi, devo sempre fare +1 per stampare l'indice dell'OG
    
    public Object invokeOperation(String op, Object[] params) throws Exception{
    	Object rispostaWS = new Object();
    	try{
            System.out.println("\n\n********** NEW OPERATION INVOCATION **********\n");
            System.out.println("Orchestrator identifier: "+id);
            System.out.println("Requested operation: "+op);
            int[] states = checkStates();
            System.out.println("Checking services' states");
            System.out.println("\tTarget state: "+targetstate);
            for(int i=0; i < services.length; i++){
                ServiceInfo si = services[i].getInfo();
                System.out.println("\tAvailable Service "+(i+1)+": name = "+si.getName()+", state = "+states[i]);
            }
            System.out.println("Orchestrator Generator interrogation");
            int index = OrchestratorDAO.searchNextService(op,targetstate, states, tablename);
            System.out.println("Orchestrator Generator output index: "+(index+1));
            if(index == -1 || index == -2){//nel caso in cui nessun servizio può fare l'operazione richiesta: non c'e' composizione quindi?
                System.out.println("Index of service selected is "+(index+1)+", no service can execute requested operation.\n Client behavior is different from target behavior or the composition is bugged");    
                throw new Exception("Unexpected behaviour of the client, the Target can't manage this request");
            }
            AvailableService as = services[index];
            Call call = as.getCall();
            ServiceInfo si = as.getInfo();
            System.out.println("Redirecting operation to service: index = "+(index+1)+" name = "+si.getName());
            call.setOperationName(new QName(si.getName(),op));
            rispostaWS = call.invoke(params);
            targetstate = OrchestratorDAO.getTargetState(targetstate,op,tablename);
            System.out.println("Target state after the operation: "+targetstate);
            System.out.println("Return operation output to client");
        }
        catch(Exception e){
            e.printStackTrace();
            throw e;
        }
        return rispostaWS;
    }
    
    private int[] checkStates() throws RemoteException{
    	int[] states = new int[services.length];
    	for(int i=0; i< states.length; i++){
            AvailableService as = services[i];
            Call call = as.getCall();
            ServiceInfo si = as.getInfo();
            call.setOperationName(new QName(si.getName(),"getStatus"));
            Object rispostaWS = call.invoke(new Object[]{});
            int st = ((Integer)rispostaWS).intValue();
            states[i] = st;
    	}
    	return states;
    }
    
    public int getTargetState(){
    	return targetstate;
    }
    
    //metodo aggiuntivo per la creazione della tabella dell'OG sul DB, nel caso in cui il target sia stato creato con il targetGenerator allora non bisogna invocare questa operazione, altrimenti è necessario.
    public void storeOGTable(String filepath) throws SQLException, IOException{
        OrchestratorDAO.storeOGTableDB(filepath);
    }
}