package dao;

import java.sql.*;
import java.io.*;
import java.util.LinkedList;

public class TGDAO {
    
    private final static String GET_ACTION_PART1 = "SELECT DISTINCT IN_ACT FROM ";
    private final static String GET_ACTION_PART2 = " WHERE NOT IN_ACT = '' AND NOT IN_ACT IS NULL AND NOT IN_ACT = 'nil' AND NOT IN_ACT = 'NIL' AND NOT IN_ACT = 'Nil' ";
    
    public static LinkedList<String> getActionNames(String table) throws SQLException{
    	Connection con = null;
		Statement st= null;
		ResultSet rs = null;
                LinkedList<String> acts = new LinkedList<String>();
		try{
                    con = ConnectionManager.getConnection();
                    con.setTransactionIsolation(Connection.TRANSACTION_SERIALIZABLE);
                    st=con.createStatement();
                    String getacts = GET_ACTION_PART1+table+GET_ACTION_PART2;
                    rs = st.executeQuery(getacts);
                    while(rs.next()){
                        String act = rs.getString(1);
                        acts.add(act);
                    }
                    if(st!=null)
                        st.close();
                    con.commit();
                    con.close();
		}catch(SQLException ex){
			ex.printStackTrace();
                        if(con!=null)
                            con.close();
			throw ex;
		}
                return acts;
	}

    public static void buildCompositionDB(String fileName) throws SQLException, IOException{
    	Connection con = null;
		Statement st= null;
		ResultSet rs = null;
		try{
			String sql = readFile(fileName);
			String[] query = sql.split(";");

			con = ConnectionManager.getConnection();
			con.setTransactionIsolation(Connection.TRANSACTION_SERIALIZABLE);
			st=con.createStatement();
			for(int i= 0; i<query.length-1; i++){
                            try{
                                st.executeUpdate(query[i]);
                            }//la drop table fallisce se non esiste la tabella, devo solo andare avanti con lo script
                            catch(com.mysql.jdbc.exceptions.MySQLSyntaxErrorException ex){
                            }
			}
			if(st!=null)
				st.close();
			con.commit();
			con.close();
			
		}catch(SQLException ex){
			ex.printStackTrace();
			con.rollback();
			con.close();
			throw ex;
		}
		catch(IOException ex){
			ex.printStackTrace();
			throw ex;
		}
	}
	

	
 	private static String readFile (String fileName ) throws IOException{
    
	    InputStreamReader isr = null;
	    StringBuffer sb = new StringBuffer ();
	    char[] buf = new char[1024];
	    int len;
	
	    try
	    {
	        FileInputStream fis = new FileInputStream (fileName);
	        isr = new InputStreamReader (fis);
	
	        while ((len = isr.read (buf)) > 0)
	            sb.append (buf, 0, len);
	
	        return sb.toString ();
	    }
	    finally
	    {
	        if (isr != null)
	            isr.close ();
	    }
}
    
    
}