package dao;

import java.io.FileInputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Logger;

import util.Config;

/**
 *
 */
public class ConnectionManager{
	private static Logger log = Logger.getLogger(ConnectionManager.class.toString());

	private static Properties properties;
	private static boolean driverLoaded = false;

	static {
		if (properties == null) {
			try {
				URL url = new ConnectionManager().getClass().getResource("/axis.properties");
				properties = new Properties();
				properties.load(new FileInputStream(URLDecoder.decode(url.getFile(), "UTF-8")));
				log.info("Properties file loaded");
			} catch (Exception e) {
				log.severe("Could not find properties file: " + e.getMessage());
				properties = null;
//				throw new Exception("Could not find properties file", e);
			}
		}
		
		if (!driverLoaded) {
			try {
				Class.forName(Config.getInstance().getProperty(Config.JDBC_DRIVER));
//				Class.forName(properties.getProperty("axis.db.driver"));
				driverLoaded = true;
			} catch(ClassNotFoundException e){
				log.severe("Driver "+Config.getInstance().getProperty(Config.JDBC_DRIVER)+" non trovato");
//				log.severe("Driver " + properties.getProperty("axis.db.driver") + " non trovato");
			}
		}
	}

	/**
	 * 
	 */
	private ConnectionManager(){
	}

	/**
	 * @return
	 * @throws SQLException
	 */
	public static Connection getConnection() throws SQLException {
		log.info("getting new connection...");
		Connection con = DriverManager.getConnection("jdbc:mysql://localhost:3306/"+Config.getInstance().getProperty(Config.DB_SCHEMA_NAME)+"?user="+Config.getInstance().getProperty(Config.DB_USER)+"&password="+Config.getInstance().getProperty(Config.DB_PASSWORD));
//		Connection con = DriverManager.getConnection(properties.getProperty("axis.db.url"), properties.getProperty("axis.db.username"), properties.getProperty("axis.db.password"));
		con.setAutoCommit(false);
		log.info("got new connection");
		return con;
	}
}
