import java.net.*;
import java.rmi.*;

import javax.xml.namespace.*;
import javax.xml.rpc.*;
import org.apache.axis.client.Service;
import org.apache.axis.client.Call;
import org.apache.axis.encoding.ser.*;
import javax.swing.JOptionPane;
import test2Community.Piatto;
import test2Community.Bibita;
import java.util.*;
public class ClientTest2 {

	public static void main(String[] args){
		String messaggio = "";
		try{
			System.out.println("Creating stateful connection with service: http://localhost:8080/axis/services/test2" );
			Call call = (Call) new Service().createCall();
			call.setTargetEndpointAddress(new URL("http://localhost:8080/axis/services/"));
			call.setMaintainSession(true);
			 
			System.out.println("Registering ComplexType mapping: Bibita, Piatto" );	
			QName qprod = new QName("urn:test2", "Piatto");
			Class cprod = Piatto.class;
			call.registerTypeMapping(cprod, qprod, BeanSerializerFactory.class, BeanDeserializerFactory.class);
			QName qprod2 = new QName("urn:test2", "Bibita");
			Class cprod2 = Bibita.class;
			call.registerTypeMapping(cprod2, qprod2, BeanSerializerFactory.class, BeanDeserializerFactory.class);
			
		 	call.setOperationName(new QName("urn:test2","getStatus"));
			Object rispostaWS = call.invoke(new Object[]{});
		    System.out.println("Target initial state: "+rispostaWS.toString());
		    
		    System.out.println("\nInvoking new operation");
		    System.out.println("Operation name: visualizzaMenu");
		    System.out.println("Parameters: none");
			call.setOperationName(new QName("urn:test2","visualizzaMenu"));
			rispostaWS = call.invoke(new Object[]{});
			Object[] o = (Object[])rispostaWS;
			System.out.println("Service output: Menu List");
			for(int i= 0; i<o.length; i++){
				Piatto p = (Piatto)o[i];
				System.out.println("\tName: "+p.getNome()+", description: "+p.getDescrizione()+",price: "+p.getPrezzo());
			}
			
			call.setOperationName(new QName("urn:test2","getStatus"));
			rispostaWS = call.invoke(new Object[]{});
			System.out.println("Target new state: "+rispostaWS.toString());
			
			System.out.println("\nInvoking new operation");
		    System.out.println("Operation name: prenotaMenu");
		    System.out.println("Parameters: pizza margherita");
			call.setOperationName(new QName("urn:test2","prenotaMenu"));
			rispostaWS = call.invoke(new Object[]{"pizza margherita"});
			Piatto p2 = (Piatto)rispostaWS;
			if(p2.isOrdine()){
				System.out.println(p2.getNome()+" has been ordered, price: "+p2.getPrezzo());
			}
			
			call.setOperationName(new QName("urn:test2","getStatus"));
			rispostaWS = call.invoke(new Object[]{});
			System.out.println("Target new state: "+rispostaWS.toString());
			
			try{
				System.out.println("\nInvoking new operation");
		    	System.out.println("Operation name: visualizzaDrink");
		    	System.out.println("Parameters: none");
		    	call.setOperationName(new QName("urn:test2","visualizzaDrink"));
				rispostaWS = call.invoke(new Object[]{});
			}
			catch(Exception ex){
				System.out.println(ex.getMessage());
				System.out.println("\nCreating a new stateful connection with service: http://localhost:8080/axis/services/test2" );
				call = (Call) new Service().createCall();
				call.setTargetEndpointAddress(new URL("http://localhost:8080/axis/services/"));
				call.setMaintainSession(true);
				System.out.println("Registering ComplexType mapping: Bibita" );	
				call.registerTypeMapping(cprod2, qprod2, BeanSerializerFactory.class, BeanDeserializerFactory.class);
				
				call.setOperationName(new QName("urn:test2","getStatus"));
			    rispostaWS = call.invoke(new Object[]{});
		        System.out.println("Target initial state: "+rispostaWS.toString());
				
				System.out.println("\nInvoking new operation");
		    	System.out.println("Operation name: visualizzaDrink");
		    	System.out.println("Parameters: none");
		    	call.setOperationName(new QName("urn:test2","visualizzaDrink"));
				rispostaWS = call.invoke(new Object[]{});
				o = (Object[])rispostaWS;
				System.out.println("Service output: drink list:");
				for(int i= 0; i<o.length; i++){
					Bibita p = (Bibita)o[i];
					System.out.println("\tname:"+p.getNome()+", liters: "+p.getLitri()+", price "+p.getPrezzo());
				}
				
				call.setOperationName(new QName("urn:test2","getStatus"));
				rispostaWS = call.invoke(new Object[]{});
				System.out.println("Target new state: "+rispostaWS.toString());
			}
		}
		catch(MalformedURLException ex){
			messaggio = "Errore: URL non è esatta";
			ex.printStackTrace();
		}
		catch(ServiceException ex){
			messaggio = "Errore creazione chiamata è fallita";
			ex.printStackTrace();
		}
		catch(RemoteException ex){
			messaggio = "Errore invocazione WS fallita";
			ex.printStackTrace();
		}
		finally{
			System.out.println(messaggio);
		}
	}
    
}