package MediaStore;

import orchestrator.*;
import javax.xml.rpc.ServiceException;
import java.util.*;

public class MediaStore {

	private Orchestrator orchestrator;
private String tablename;

	public MediaStore() throws Exception{ 
		tablename = "MediaStore";
		ServiceInfo[] services = new ServiceInfo[4];
		services[0] = new ServiceInfo("http://127.0.0.1:8080/axis/services/", "urn:CartManagement");
		services[1] = new ServiceInfo("http://127.0.0.1:8080/axis/services/", "urn:ProductList");
		services[2] = new ServiceInfo("http://127.0.0.1:8080/axis/services/", "urn:CheckOutService");
		services[3] = new ServiceInfo("http://127.0.0.1:8080/axis/services/", "urn:BuyService");
		LinkedList<Class> complexTypes = new LinkedList<Class>();
		complexTypes.add(Product.class);
		orchestrator = new Orchestrator(services, tablename, complexTypes);
	}

	public Product addToCart(Product in0)throws Exception{ 
		Object[] params = {in0};
		Object risposta = orchestrator.invokeOperation("addToCart", params);
		return (Product)risposta;
	}

	public java.util.Vector viewCart()throws Exception{ 
		Object[] params = {};
		Object risposta = orchestrator.invokeOperation("viewCart", params);
		return (java.util.Vector)risposta;
	}

	public void removeFromCart(Product in0)throws Exception{ 
		Object[] params = {in0};
		Object risposta = orchestrator.invokeOperation("removeFromCart", params);
	}

	public java.util.Vector getProductList()throws Exception{ 
		Object[] params = {};
		Object risposta = orchestrator.invokeOperation("getProductList", params);
		return (java.util.Vector)risposta;
	}

	public String buy(double in0)throws Exception{ 
		Object[] params = {in0};
		Object risposta = orchestrator.invokeOperation("buy", params);
		return (String)risposta;
	}

	public double checkOut(java.util.Vector in0)throws Exception{ 
		Object[] params = {in0};
		Object risposta = orchestrator.invokeOperation("checkOut", params);
		return (Double)risposta;
	}

	public int getStatus(){  return orchestrator.getTargetState(); } 
 
}