/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.alg.util.VertexDegreeComparator;
import org.jgrapht.graph.Subgraph;
import org.jgrapht.graph.UndirectedSubgraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VertexCovers {
    public static <V, E> Set<V> find2ApproximationCover(Graph<V, E> graph) {
        HashSet<V> hashSet = new HashSet<V>();
        Subgraph<V, E> subgraph = new Subgraph<V, E>(graph, null, null);
        while (subgraph.edgeSet().size() > 0) {
            E e = subgraph.edgeSet().iterator().next();
            V v = graph.getEdgeSource(e);
            V v2 = graph.getEdgeTarget(e);
            hashSet.add(v);
            hashSet.add(v2);
            subgraph.removeVertex(v);
            subgraph.removeVertex(v2);
        }
        return hashSet;
    }

    public static <V, E> Set<V> findGreedyCover(UndirectedGraph<V, E> undirectedGraph) {
        HashSet hashSet = new HashSet();
        UndirectedSubgraph undirectedSubgraph = new UndirectedSubgraph(undirectedGraph, null, null);
        VertexDegreeComparator<V, E> vertexDegreeComparator = new VertexDegreeComparator<V, E>(undirectedSubgraph);
        while (undirectedSubgraph.edgeSet().size() > 0) {
            Object v = Collections.max(undirectedSubgraph.vertexSet(), vertexDegreeComparator);
            hashSet.add(v);
            undirectedSubgraph.removeVertex(v);
        }
        return hashSet;
    }
}

