/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.traverse.DepthFirstIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CycleDetector<V, E> {
    Graph<V, E> graph;

    public CycleDetector(DirectedGraph<V, E> directedGraph) {
        this.graph = directedGraph;
    }

    public boolean detectCycles() {
        try {
            this.execute(null, null);
        }
        catch (CycleDetectedException cycleDetectedException) {
            return true;
        }
        return false;
    }

    public boolean detectCyclesContainingVertex(V v) {
        try {
            this.execute(null, v);
        }
        catch (CycleDetectedException cycleDetectedException) {
            return true;
        }
        return false;
    }

    public Set<V> findCycles() {
        HashSet hashSet = new HashSet();
        this.execute(hashSet, null);
        return hashSet;
    }

    public Set<V> findCyclesContainingVertex(V v) {
        HashSet hashSet = new HashSet();
        this.execute(hashSet, v);
        return hashSet;
    }

    private void execute(Set<V> set, V v) {
        ProbeIterator probeIterator = new ProbeIterator(set, v);
        while (probeIterator.hasNext()) {
            probeIterator.next();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ProbeIterator
    extends DepthFirstIterator<V, E> {
        private List<V> path;
        private Set<V> cycleSet;

        ProbeIterator(Set<V> set, V v) {
            super(CycleDetector.this.graph, v);
            this.cycleSet = set;
            this.path = new ArrayList();
        }

        @Override
        protected void encounterVertexAgain(V v, E e) {
            int n;
            super.encounterVertexAgain(v, e);
            if (n > -1) {
                if (this.cycleSet == null) {
                    throw new CycleDetectedException();
                }
                for (n = this.path.indexOf(v); n < this.path.size(); ++n) {
                    this.cycleSet.add(this.path.get(n));
                }
            }
        }

        @Override
        protected V provideNextVertex() {
            Object v = super.provideNextVertex();
            for (int i = this.path.size() - 1; i >= 0 && !CycleDetector.this.graph.containsEdge(this.path.get(i), v); --i) {
                this.path.remove(i);
            }
            this.path.add(v);
            return v;
        }
    }

    private static class CycleDetectedException
    extends RuntimeException {
        private static final long serialVersionUID = 3834305137802950712L;

        private CycleDetectedException() {
        }
    }
}

