package giocatore;

import java.util.List;

import squadra.*;
import _framework.*;
import _gestioneeventi.*;
import contiene.*;
import eventi.*;
import giocatore.Giocatore.Stato;

class GiocatoreFired implements Task {
	private boolean eseguita = false;
	private Giocatore g;
	private Evento e;

	public GiocatoreFired(Giocatore g, Evento e) {
		this.g = g;
		this.e = e;
	}

	public synchronized void esegui(Executor exec) {
		if (eseguita || exec == null
				|| (e.getDestinatario() != g && e.getDestinatario() != null))
			return;
		eseguita = true;
		switch (g.getStato()) {
		case ALLENAMENTO:
			if (e.getClass() == Inizio.class) {
				g.trattopercorso = 0;
				g.statocorrente = Stato.INGIOCO;
			}
			break;
		case INGIOCO:
			if (e.getClass() == Bastone.class)
				if (g.trattopercorso < 100) {
					System.out.println(g + ": " + g.trattopercorso);
					g.trattopercorso = g.trattopercorso + Math.random()
							* g.getVelocita() + 1;
					Environment.aggiungiEvento(new Bastone(g, g));
					g.statocorrente = Stato.INGIOCO;
				} else { // trattopercorso >= 100
					System.out.println(g + ": " + g.trattopercorso);
					Squadra sc = g.getLinkContiene().getSquadra();
					List<TipoLinkContiene> links = sc.getLinkContiene();
					int i = links.indexOf(new TipoLinkContiene(sc, g));
					if (i + 1 < sc.getLinkContiene().size()) {
						Giocatore prossimo = links.get(i + 1).getGiocatore();
						Environment.aggiungiEvento(new Bastone(g, prossimo));
					}
					g.statocorrente = Stato.FINEGIOCO;
				}
			break;
		case FINEGIOCO:
			if (e.getClass() == Fine.class)
				g.statocorrente = Stato.ALLENAMENTO;
			break;
		default:
			throw new RuntimeException("Stato corrente non riconosciuto.");
		}
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}
}
