package attivita_composte;

import attivita_atomiche.*;
import _framework.*;
import _gestioneeventi.*;
import gara.*;
import squadra.*;
import eventi.*;

public class AttivitaPrincipale implements Runnable {
	private boolean eseguita = false;

	// Qui ci va il codice che realizza il diagramma delle attivita'
	public synchronized void run() {
		if (eseguita == true)
			return;
		eseguita = true;
		Squadra s1;
		Squadra s2;
		Gara g;
		// crea prima squadra
		CreaSquadra csq1 = new CreaSquadra("Roadrunners");
		Executor.perform(csq1);
		s1 = csq1.getSquadra();
		// crea seconda squadra
		CreaSquadra csq2 = new CreaSquadra("Speedygonzales");
		Executor.perform(csq2);
		s2 = csq2.getSquadra();
		// crea gara
		CreaGara cg = new CreaGara("La Gara", s1, s2);
		Executor.perform(cg);
		g = cg.getGara();
		// stampa gara
		Stampa.stampaGara(g);

		// esegui gara
		System.out.println("INIZIO GARA");
		Executor.perform(new InizializzaEnvironment(g));
		System.out.println("Stato environment: " + EsecuzioneEnvironment.getStato());
		EsecuzioneEnvironment.attivaListener();
		System.out.println("Stato environment: " + EsecuzioneEnvironment.getStato());
		try {
			Thread.sleep(10); // diamo tempo di terminare la gara
		} catch (InterruptedException e) {
		}
		boolean fatto;
		do {
			TestFineGara t = new TestFineGara(g);
			Executor.perform(t);
			try {
				Thread.sleep(10); // diamo tempo di terminare la verifica
			} catch (InterruptedException e) {
			}
			fatto = t.estEseguita() && t.estGaraFinita();
		} while (!fatto);
		Environment.aggiungiEvento(new Fine(null, null)); 
		System.out.println("FINE GARA");
		
		//disattiva l'environment
		EsecuzioneEnvironment.disattivaListener();
		System.out.println("Stato environment: " + EsecuzioneEnvironment.getStato());
		
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}
}
