package attivita_atomiche;

import _framework.*;
import squadra.*;
import contiene.*;
import giocatore.*;

public class CreaSquadra implements Task {

	private boolean eseguita = false;
	private Squadra squadra;


	public CreaSquadra(String nome) {
		squadra = new Squadra(nome);
	}

	public synchronized void esegui(Executor e) {
		
		if (e == null || eseguita == true)
			return;
		eseguita = true;

		for (int i=0; i < 10; i++) 
			squadra.inserisciLinkContiene(new TipoLinkContiene(squadra,new Giocatore(squadra.getNome()+i,i*10+1)));
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}
	

	public synchronized Squadra getSquadra() {
		if (!eseguita) return null;
		return squadra;
	}
	

}