package attivita_atomiche;

import _framework.*;
import squadra.*;
import gara.Gara;

public class CreaGara implements Task {

	private boolean eseguita = false;
	private Gara gara;
	private Squadra s1, s2;

	public CreaGara(String nome, Squadra s1, Squadra s2) {
		gara = new Gara(nome);
		this.s1 = s1;
		this.s2 = s2;
	}

	public synchronized void esegui(Executor e) {
		
		if (e == null || eseguita == true)
			return;
		eseguita = true;

		gara = new Gara("La Gara");	
		gara.inserisciLinkPartecipa(s1);
		gara.inserisciLinkPartecipa(s2);
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}
	

	public synchronized Gara getGara() {
		if (!eseguita) return null;
		return gara;
	}
	

}