package mattoncino;

import java.util.*;

import mattoncino.Mattoncino.Stato;

import _framework.*;
import _gestioneeventi.*;
import eventi.*;

public class MattoncinoFired implements Task {
	private boolean eseguita = false;
	private Mattoncino m;
	private Evento e;
	

	public MattoncinoFired(Mattoncino m, Evento e) {
		this.m = m;
		this.e = e;
	}

	public synchronized void esegui(Executor exec) {
		if (eseguita || exec == null
				|| (e.getDestinatario() != m && e.getDestinatario() != null))
			return;
		eseguita = true;
		switch (m.getStato()) {
		case SPENTO:
			if (e.getClass() == IniziaBlu.class) {
				m.statocorrente = Stato.BLU;
				Environment.aggiungiEvento(new Evento(m, m));
			} else if (e.getClass() == IniziaRosso.class) {
				m.statocorrente = Stato.ROSSO;
				Environment.aggiungiEvento(new Evento(m, m));
			}
			System.out.println(m.getCodice() + " --> " + m.statocorrente);
			break;
		case BLU:
		case ROSSO:
			if (e.getClass() == Evento.class) {
				Iterator<Mattoncino> i = m.getLinkCollegato().iterator();
				int blu = 0;
				int rosso = 0;
				while (i.hasNext()) {
					Mattoncino mm = i.next();
					if (mm.getStato() == Stato.BLU)
						blu++;
					else if (mm.getStato() == Stato.ROSSO)
						rosso++;
				}
				if (blu > rosso)
					m.statocorrente = Stato.BLU;
				else if (blu < rosso)
					m.statocorrente = Stato.ROSSO;
				Environment.aggiungiEvento(new Evento(m, m));
			}
			if (e.getClass() == Spegniti.class)
				m.statocorrente = Stato.SPENTO;
			System.out.println(m.getCodice() + " --> " + m.statocorrente);
			break;
		default:
			throw new RuntimeException("Stato corrente non riconosciuto.");
		}
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}
}
