package attivita_composte;

import java.util.*;

import mattoncino.Mattoncino;
import attivitaIO.AttivitaIO;
import attivita_atomiche.*;
import _framework.*;
import _gestioneeventi.*;
import eventi.*;

public class AttivitaPrincipale implements Runnable {
	private boolean eseguita = false;

	// Qui ci va il codice che realizza il diagramma delle attivita'
	public synchronized void run() {
		if (eseguita == true)
			return;
		eseguita = true;
		
		List<Mattoncino> lista;
		
		//crea 20 mattonini
		lista = AttivitaIO.creaMattoncini(20);
		
		//stampa mattoncini
        AttivitaIO.stampaMattoncini(lista);
        
		// crea connessioni tra mattoncini
		CreaCollegamenti cc = new CreaCollegamenti(lista);
		Executor.perform(cc);
		

		// esegui interazione
		System.out.println("INIZIO INTERAZIONE");
		Executor.perform(new InizializzaEnvironment(lista));
		System.out.println("Stato environment: " + EsecuzioneEnvironment.getStato());
		EsecuzioneEnvironment.attivaListener();
		System.out.println("Stato environment: " + EsecuzioneEnvironment.getStato());
		try {
			Thread.sleep(10); // diamo tempo di terminare la gara
		} catch (InterruptedException e) {
		}
		boolean fatto;
		do {
			TestFineInterazione t = new TestFineInterazione(lista);
			Executor.perform(t);
			try {
				Thread.sleep(10); // diamo tempo di terminare la verifica
			} catch (InterruptedException e) {
			}
			fatto = t.estEseguita() && t.estInterazioneFinita();
		} while (!fatto);
		
		//stampa mattoncini   
		Environment.aggiungiEvento(new Spegniti(null, null)); 
		System.out.println("FINE INTERAZIONE");
		
		//disattiva l'environment
		EsecuzioneEnvironment.disattivaListener();
		System.out.println("Stato environment: " + EsecuzioneEnvironment.getStato());
		AttivitaIO.stampaMattoncini(lista);
		
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}
}
