package attivita_atomiche;

import java.util.*;
import mattoncino.*;
import _framework.*;

public class TestFineInterazione implements Task {
	private boolean eseguita = false;
	private List<Mattoncino> lista;
	private boolean interazionefinita;

	public TestFineInterazione(List<Mattoncino> l) {
		lista = l;
	}

	public synchronized void esegui(Executor e) {
		if (e == null || eseguita == true)
			return;
		eseguita = true;
		interazionefinita = true;
		for (int i = 0; i < lista.size() && interazionefinita; i++) {
			Mattoncino m = lista.get(i);
			Iterator<Mattoncino> it = m.getLinkCollegato().iterator();
			while (it.hasNext() && interazionefinita) {
				Mattoncino mm = it.next();
				if (m.getStato() != mm.getStato()) 
				interazionefinita = false;
			}
		}
	}

	public synchronized boolean estInterazioneFinita() {
		if (!eseguita)
			throw new RuntimeException();
		return interazionefinita;
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}

}
