package listlistadoppia;


import java.util.*;
import java.lang.reflect.Array;

class Nodo {
  Object info;
  Nodo next;
  Nodo prev;
  Nodo(Object i, Nodo n, Nodo p) {
    info = i;
    next = n;
    prev =p;
  }
}

public class ListListaDoppia implements List {
  
  protected int numElem;
  protected Nodo sentinella;

  // costruttore 
  public ListListaDoppia() {
    numElem = 0;
    sentinella = new Nodo(null,null,null);
    sentinella.next = sentinella;
    sentinella.prev = sentinella;
  }


  // funzioni interfaccia Collection

  // Basic Operations
  public int size() {
    return numElem;
  }

  public boolean isEmpty() {
    return sentinella.next == sentinella;
    // oppure return sentinella.prev == sentinella;
  }

  public boolean contains(Object element) {
    return trova(element) != sentinella;
  }

  public boolean add(Object element) {
    Nodo pos = sentinella;
    Nodo aux = new Nodo(element,pos,pos.prev);
    pos.prev.next = aux;
    pos.prev = aux;
    numElem++;
    return true;
  }
  
  public boolean remove(Object element) {
    Nodo pos = trova(element);
    if (pos!=sentinella) {
      pos.prev.next = pos.next;
      pos.next.prev = pos.prev;
      numElem--;
      return true;
    }
    else return false;
  }
  
  public Iterator iterator() {
    return new ListIteratorListaDoppia(this);
  }

  public boolean containsAll(Collection c) {
    Iterator it = c.iterator();
    while (it.hasNext()) {
      Object e = it.next();
      if (!contains(e)) return false;
    }
    return true;
  }

  public boolean addAll(Collection c){ 
    throw new UnsupportedOperationException("addlAll() non e' supportata");
  }
  public boolean removeAll(Collection c) {
    throw new UnsupportedOperationException("removeAll() non e' supportata");
  }
  public boolean retainAll(Collection c) {
    throw new UnsupportedOperationException("retainAll() non e' supportata");
  }
  public void clear() {
    throw new UnsupportedOperationException("clear() non e' supportata");
  }

  // array operations
  public Object[] toArray() {
    Object[] a = new Object[size()];
    int i = 0;
    Iterator it = iterator();
    while (it.hasNext()) {
      a[i] = it.next();
      i++;
    }
    return a;
  }

  public Object[] toArray(Object[] a) {
    if (a.length < size()) {
      //prendi il tipo degli elementi di a
      Class elemClass = a.getClass().getComponentType(); 
      //costruisci un array il cui tipo degli elementi e' quello in a
      a = (Object[])Array.newInstance(elemClass,size());
    }
    //riempi l'array con gli elementi della collezione
    int i = 0;
    Iterator it = iterator();
    while (it.hasNext()) {
      a[i] = it.next();
      i++;
    }
    for (; i < a.length; i++) 
      a[i] = null;
    return a;  
  } 

  // funzioni interfaccia List

  // Positional Access
  public Object get(int index) {
    return trova(index).info;
  }

  public Object set(int index, Object element) {
    Nodo pos = trova(index);
    Object old = pos.info;
    pos.info = element;
    return old;
  }

  public void add(int index, Object element) {
    Nodo pos = trova(index);
    Nodo aux = new Nodo(element,pos,pos.prev);
    pos.prev.next = aux;
    pos.prev = aux;
    numElem++;
  }

  public Object remove(int index) {
    Nodo pos = trova(index);
    pos.prev.next = pos.next;
    pos.next.prev = pos.prev;
    numElem--;
    return pos.info;
  }
    
  public boolean addAll(int index, Collection c) {
    throw new UnsupportedOperationException("addlAll() non e' supportata");
  }

  // Search
  public int indexOf(Object o) {
    int index = 0;
    Nodo l = sentinella.next;
    while (l!=sentinella) {
      if (l.info.equals(o)) return index;
      index++;
      l = l.next;
    }
    return -1;
  }
    
  
  public int lastIndexOf(Object o) {
    int index = numElem-1;
    Nodo l = sentinella.prev;
    while (l!=sentinella) {
      if (l.info.equals(o)) return index;
      index--;
      l = l.prev;
    }
    return -1;
  }
  
  // Iteration
  public ListIterator listIterator() {
    return new ListIteratorListaDoppia(this);
  }

  public ListIterator listIterator(int index) {
    return new ListIteratorListaDoppia(this,index);
  }

  // Range-view
  public List subList(int from, int to) { //non supportiamo operazioni
                                          //di view!
    throw new UnsupportedOperationException("subList() non e' supportata");
  }


  // funzioni speciali ereditate da Object

  public boolean equals(Object o) {
    if (o != null && getClass().equals(o.getClass())) {
      ListListaDoppia list = (ListListaDoppia)o;
      if (numElem != list.numElem) return false;
      // list non ha la dimensione giusta
      else {
        Nodo l1 = sentinella.next;
        Nodo l2 = list.sentinella.next;
        while (l1 != sentinella) {
          if (!l1.info.equals(l2.info))
            return false;
          l1 = l1.next;
          l2 = l2.next;
        }
        return true;
      }
    }
    else return false;
  }

  public Object clone() {
    try {
      ListListaDoppia list = (ListListaDoppia) super.clone();
      // chiamata a clone() di Object che esegue la copia campo a campo;
      // questa copia e' sufficiente per i campi cardinalita e elemClass
      // ma non per il campo inizio del quale va fatta una copia profonda
      list.sentinella = copia(sentinella);
      return list;
    } catch(CloneNotSupportedException e) {
      // non puo' accadere perche' implementiamo l'interfaccia cloneable,
      // ma va comunque gestita
      throw new InternalError(e.toString());
    }
  }
  public String toString() {
    String s = "( ";
    Nodo l = sentinella.next;
    while (l != sentinella) {
      s = s + l.info + " ";
      l = l.next;
    }
    s = s + ")";
    return s;
  }

  
  // funzioni ausiliarie
  
  private Nodo trova(Object o) {
    Nodo l = sentinella.next;
    while (l!=sentinella) {
      if (l.info.equals(o)) return l;
      l = l.next;
    }
    return sentinella;
  }

  private Nodo trova(int index) {
    if (index < 0 || index > size()) throw new IndexOutOfBoundsException();
    Nodo l = sentinella.next;
    for (int i = 0; i < index; i++)
      l = l.next;
    return l;
  }

  private Nodo copia(Nodo l) {
    Nodo rsentinella = new Nodo(null,null,null);
    rsentinella.next = rsentinella;
    rsentinella.prev = rsentinella;
    l = l.next;
    Nodo rl = rsentinella;
    while (l!=sentinella) {
      Nodo aux = new Nodo(l.info,rl.next,rl);
      rl.next.prev = aux;
      rl.next = aux;
      l = l.next;
      rl = rl.next;
    }
    return rsentinella;
  }
}
