package listlistadoppia;

import java.util.*;


class ListIteratorListaDoppia implements ListIterator {

  Nodo pos;
  ListListaDoppia lista;
  int posindex;
  
  
  ListIteratorListaDoppia(ListListaDoppia lista) {
    this.lista=lista;
    pos = lista.sentinella.next;
    posindex = 0;
  }

  ListIteratorListaDoppia(ListListaDoppia lista, int index) {
    this.lista=lista;
    pos = lista.sentinella.next;
    posindex = index;
    if (index < 0 || index > lista.size()) 
      throw new IndexOutOfBoundsException(); 
    for (int i = 0; i < index; i++) {
      pos = pos.next;
    }
  }
  
  public boolean hasNext() {
    return pos!=lista.sentinella;
  }

  public Object next() {
    if (pos == lista.sentinella) throw new NoSuchElementException();
    pos = pos.next;
    posindex++;    
    return pos.prev.info;
  }

  public boolean hasPrevious() {
    return pos.prev != lista.sentinella;
  }

  public Object previous() {
    if (pos.prev == lista.sentinella) throw new NoSuchElementException();
    pos = pos.prev;
    posindex--;
    return pos.info;
  }

  public int nextIndex() {
    return posindex;
  }
  public int previousIndex(){
    return posindex - 1;
  }

  public void remove() {
    throw new UnsupportedOperationException("remove() non e' supportata");
  }
  public void set(Object o) {
    throw new UnsupportedOperationException("set() non e' supportata");
  }
  public void add(Object o) {
    throw new UnsupportedOperationException("add() non e' supportata");
  }
}
