import processi.*;
import listlistadoppia.*;
import java.util.*;

public class Sequencer{
  
  private List lista;
  
  public Sequencer(){
    lista = new ListListaDoppia();   
  } 
  
  public void aggiungiProcesso(Processo p){
    lista.add(p); // add si comporta come richiesto dalla specifica di aggiungiProcesso
  }
  public void rimuoviProcesso(Processo p){
    lista.remove(p); // remove si comporta come richiesto dalla specifica di rimuoviProcesso
  }	
  public void rimuoviProcessiTipo(String t){
    ListListaDoppia aux = (ListListaDoppia) processiDiTipo(t); // lista dei processi di tipo t
    ListIterator it = aux.listIterator();
    while (it.hasNext()){ //in generale non e' safe modificare la lista mentre la si scandisce con un iteratore
      Processo proc = (Processo)it.next();                                    
      lista.remove(proc); 
    }
  }	
  
  public int quantiProcessi(){
    return lista.size();
  }
  
  public Processo primoProcesso(){
    return (Processo)lista.get(0); // get(0) si comporta come richiesto dalla specifica di primoProcesso
  }
  
  public Processo ultimoProcesso(){
    if (lista.size()>0)
      return (Processo)lista.get(lista.size()-1);
    else return null;
  }
  
  public Processo primoProcessoTipo(String t){
    Iterator it = lista.iterator();
    while(it.hasNext()){
      Processo aux = (Processo) it.next();
      if(aux.getTipo().equals(t))
        return aux;
    }
    return null;	
  }
  
 
  
  public Processo ultimoProcessoTipo(String t){
    ListIterator it = lista.listIterator(lista.size()); 
    while(it.hasPrevious()){
      Processo aux = (Processo) it.previous();
      if(aux.getTipo().equals(t))
        return aux;
    }
    return null;	
  }
 
  
  public Processo processoPrimaDi(Processo p){ 
    int indice = lista.indexOf(p); // indice == -1 se p non appartiene alla lista
    if(indice >0 && lista.size()>1)
      return (Processo)lista.get(indice-1);
    else return null;
  }
  
  public Processo processoDopoDi(Processo p){
    int indice = lista.indexOf(p); // indice == -1 se p non appartiene alla lista
    if(indice >0 && lista.size()>1 && indice < lista.size()-1 )
      return (Processo)lista.get(indice+1);
    else return null; 
  }
  
  public Processo processoStessoTipoPrimaDi(Processo p){
  	if (lista.contains(p)){
      ListIterator it = lista.listIterator(lista.indexOf(p));
      while(it.hasPrevious()) {
        Processo proc = (Processo)it.previous();
        if(proc.getTipo().equals(p.getTipo()))
          return proc;
      }
      return null;
    }
    return null;	
  }
  
  
  
  public Processo processoStessoTipoDopoDi(Processo p){
  	if (lista.contains(p)){
      ListIterator it = lista.listIterator(lista.indexOf(p));
      if (it.hasNext()) { // devo saltare l'elemento corrente che e' proprio p
        it.next(); 
        while(it.hasNext()){
          Processo proc = (Processo) it.next();
          if(proc.getTipo().equals(p.getTipo()))
            return proc;
        }
        return null;
      }	
      else return null;
     }
     return null;	
  }
  
  
  public void spostaInTesta(Processo p){
    if(lista.contains(p) && lista.size()>1){
      lista.remove(p);
      lista.add(p); // add effettua l'inserimento in testa
    }  
  }
  
  
  
  
  public List processiDiTipo(String t){
    List aux = new ListListaDoppia();
    ListIterator it = lista.listIterator(lista.size());
    while (it.hasPrevious()){ /* add inserisce in testa, quindi per inserire in aux i processi nelll'ordine 
                                 con cui sono stati inseriti in lista, occorre scandire quest'ultima all'indietro*/
      Processo proc = (Processo) it.previous();
      if (proc.getTipo().equals(t))
        aux.add(proc);
    }
    return aux;
  }
  
  public Set tipiDiProcessi(){
    Set aux = new HashSet();
    Iterator it = lista.iterator();
    while(it.hasNext()){
      Processo proc = (Processo)it.next();
      aux.add(proc.getTipo());
    }
    return aux;
  }

  public String toString(){
    String aux = "";
    ListIterator it = lista.listIterator();
    while(it.hasNext()){
      Processo p = (Processo)it.next();
      aux = aux + p.toString()+"\n";
    }
    return aux;
  }	
}
