package emergenza;

public class TipoLinkContiene 
{
	private final Area area;
	private final Edificio edif;
	
	public TipoLinkContiene(Area area, Edificio edif) throws EccezionePrecondizioni
	{
		if (area==null || edif==null)
			throw(new EccezionePrecondizioni("Non ammessi valori nulli"));
		this.area=area;
		this.edif=edif;
	}

	public Area getArea() {
		return area;
	}

	public Edificio getEdificio() {
		return edif;
	}

	public int hashCode() {
		return area.hashCode()+edif.hashCode();
	}

	public boolean equals(Object obj) {
		if (getClass() != obj.getClass())
			return false;
		TipoLinkContiene other = (TipoLinkContiene) obj;
		return(area==other.area && edif==other.edif);
	}
	

}
