package emergenza;

import java.util.*;

public class Modello 
{
	private static Hashtable<String,Edificio> edifici=new Hashtable<String, Edificio>();
	private static Hashtable<String,Area> aree=new Hashtable<String, Area>();
	private static Hashtable<String,Persona> persone=new Hashtable<String, Persona>();
	
	public static void aggiungiPersona(Persona p)
	{
		if (!persone.containsKey(p.getNominativo()))
			persone.put(p.getNominativo(), p);		
	}
	
	
	/**
	 * Aggiunge un nuovo edificio all'archivio. Fallisce nel caso che esiste gi
	 * un edificio allo stesso indirizzo. 
	 * @param edificio L'edificio da aggiungere. 
	 */
	public static void aggiungiEdificio(Edificio edificio)
	{
		if (!edifici.containsKey(edificio.getIndirizzo()))
			edifici.put(edificio.getIndirizzo(), edificio);
	}
	
	/**
	 * Restituisce l'oggetto Edificio associato ad un certo indirizzo
	 * @param indirizzo La stringa contenente l'indirizzo
	 * @return L'oggetto Edificio. 
	 */
	public static Edificio getEdificioByIndirizzo(String indirizzo)
	{
		return(edifici.get(indirizzo));
	}

	public static Collection<Area> getListaAree()
	{
		return(Collections.unmodifiableCollection(aree.values()));
	}
	
	public static Area getAreaByNome(String nome)
	{
		return(aree.get(nome));
	}
	
	public static List<Ospedale> getListaOspedali(boolean soloAgibili)
	{
		Iterator<Edificio> iter=edifici.values().iterator();
		LinkedList<Ospedale> lista=new LinkedList<Ospedale>();
		while(iter.hasNext())
		{	
			Edificio edif=iter.next();
			if (edif instanceof Ospedale)
			{
				Ospedale osp=(Ospedale)edif;
				if (!soloAgibili || osp.isAgibile())
					lista.add(osp);
			}
		}
		return lista;
	}
	
	public static Ospedale getOspedaleByNome(String nome)
	{
		Iterator<Edificio> iter=edifici.values().iterator();
		while(iter.hasNext())
		{
			Edificio successivo=iter.next();
			if (successivo.getClass() == Ospedale.class)
			{
				Ospedale osped=(Ospedale)successivo;
				if (osped.getNome().equals(nome))
					return(osped);
			}
		}
		return(null);
	}
	
	/**
	 * Restituisce la lista degli edifici. La collezione restituita
	 * non  modificabile. 
	 * @return Una collezione generica di oggetti Edificio.
	 */
	public static Collection<Edificio> getEdifici()
	{
		return(Collections.unmodifiableCollection(edifici.values()));
	}

	public static void aggiungiArea(Area unArea) 
	{
		if (!aree.containsKey(unArea.getNome()))
			aree.put(unArea.getNome(), unArea);
		
	}
	
	
}
