package emergenza;

import java.util.*;

public class Edificio 
{
	private boolean agibile=false;
	private final String indirizzo;
	private TipoLinkContiene link=null;
	private HashSet<TipoLinkCollocazione> insiemeLink=new HashSet<TipoLinkCollocazione>();
	
	public Edificio(String indirizzo)
	{
		this.indirizzo=indirizzo;
	}

	public boolean isAgibile() {
		return agibile;
	}

	public void setAgibile(boolean agibile) {
		this.agibile = agibile;
	}

	public String getIndirizzo() {
		return indirizzo;
	}
	
	public void inserisciLinkComprende(TipoLinkCollocazione t) {
		if (t != null && t.getEdificio() == this)
			ManagerCollocazione.inserisci(t);
	}

	public void inserisciLinkPerManagerCollocazione(ManagerCollocazione k) 
	{
		if (k!=null)
		{
			insiemeLink.add(k.getLink());
		}
	}	
	
	public void inserisciLinkComprende(TipoLinkContiene t) {
		if (t != null && t.getEdificio() == this)
			ManagerContiene.inserisci(t);
	}

	public void inserisciLinkPerManagerContiene(ManagerContiene k) 
	{
		if (k!=null)
		{
			link=k.getLink();
		}
	}

	public int numeroPersone()
	{
		return insiemeLink.size();
	}
	
	@SuppressWarnings("unchecked")
	public Set<TipoLinkCollocazione> getLinkCollocazione() throws EccezioneCardMinMax
	{
		//DA COMPLETARE A CURA DELLO STUDENTE
		//Eliminare la riga successiva:
		return(null);
	}
	
	public TipoLinkContiene getLinkContiene() throws EccezioneCardMinMax 
	{
		return link;
	}
	
	public int numeroPersoneFerite()
	{
		Iterator<TipoLinkCollocazione> iter=insiemeLink.iterator();
		int numPersFerite=0;
		while(iter.hasNext())
		{
			Persona p=iter.next().getPersona();
			if (p.getClass()==PersonaSuperstite.class)
			{
				PersonaSuperstite pv=(PersonaSuperstite) p;
				if (pv.getTipoLinkRecovero()!=null)
					numPersFerite++;
			}
		}
		return numPersFerite;		
	}
	
	public int numeroPersoneSuperstiti()
	{
		Iterator<TipoLinkCollocazione> iter=insiemeLink.iterator();
		int numPersVive=0;
		//DA COMPLETARE A CURA DELLO STUDENTE
		return numPersVive;
	}	
	
	public int numeroPersoneVittime()
	{
		Iterator<TipoLinkCollocazione> iter=insiemeLink.iterator();
		int numPersMorte=0;
		//DA COMPLETARE A CURA DELLO STUDENTE
		return numPersMorte;
	}
	
	public String toString()
	{
		return indirizzo;
	}
	
}
