package gui;

import javax.swing.JOptionPane;
import java.util.*;
import colonie.colonia.*;

public class AttivitaIO {
	public static RecordRegione chiediNomeLato(){
		String nome=JOptionPane.showInputDialog(null,"Nome della regione:");
		if (nome==null)
			return null;
		int lato=0;
		try{		
			lato = Integer.parseInt(JOptionPane.showInputDialog(null,"Dimensione lato della regione:"));
		} 
		catch (NumberFormatException e){
			return null;
		}

		return new RecordRegione(nome, lato);
	}
	
	public static Set<Colonia> impostazioneIniziale(FinestraRegione finestraRegione){
		try{
			finestraRegione.setVisible(true);// Mostra la finestra per l'impostazione iniziale
			finestraRegione.getSemaforo().await();// aspetta che sia premuto il tasto avvio nella finestra
		}
		catch (Exception e){
			e.printStackTrace();
			System.exit(1);
		}
		// Restituisce l'impostazione corrente (iniziale) delle colonie, come specificato dall'utente
		return finestraRegione.getImpostazioneCorrente();
	}	
	
	public static void attendiFineSimulazione(FinestraRegione finestraRegione){
		finestraRegione.resetSemaforo();
		try{
			finestraRegione.getSemaforo().await();
		}
		catch (InterruptedException e){
			e.printStackTrace();
			System.exit(1);
		}
	}
	
}
