package colonie.colonia;

import colonie.*;
import _framework.*;
import _gestioneeventi.*;
import gui.*;

public class Colonia implements Listener{
	private TipoLinkContiene contiene;
	private TipoLinkColonna nord = null;
	private TipoLinkColonna sud = null;
	private TipoLinkRiga est = null;
	private TipoLinkRiga ovest = null;
	private boolean inizializzata = false;
	
	private FinestraRegione finestraRegione;// SOLO PER SCOPI GRAFICI
	
	public Colonia(FinestraRegione finestraRegione){
		this.finestraRegione = finestraRegione;// SOLO PER SCOPI GRAFICI
	}
	
	TipoLinkContiene getContiene() throws EccezioneCardMinMax{
		if (contiene == null)
			throw new EccezioneCardMinMax("Cardinalita' min/max violata");
		return contiene;
	}
	
	public TipoLinkColonna getLinkNord(){
		return nord;
	}

	public TipoLinkColonna getLinkSud(){
		return sud;
	}

	public TipoLinkRiga getLinkOvest(){
		return ovest;
	}

	public TipoLinkRiga getLinkEst(){
		return est;
	}

	
	public void inserisciLinkContiene(TipoLinkContiene l){	
		if (l != null && l.getColonia() == this){
			ManagerContiene.inserisci(l);
		}
	}
	
	public void inserisciPerManagerContiene(ManagerContiene m){
		if (m != null){
			contiene = m.getLink();
		}
	}
	
	public void eliminaLinkContiene(TipoLinkContiene l){	
		if (l != null && l.getColonia() == this){
			ManagerContiene.elimina(l);
		}
	}
	
	public void eliminaPerManagerContiene(ManagerContiene m){
		if (m != null && contiene.equals(m.getLink())){
			contiene=null;
		}
	}
	
	public void inserisciLinkColonnaNord(TipoLinkColonna l){
		if (l!=null && l.getSud() == this){
			ManagerColonna.inserisci(l);
		}
	}
	
	public void inserisciPerManagerColonnaNord(ManagerColonna m){
		if(m!=null){
			nord = m.getLink();
		}
	}
	
	public void inserisciLinkColonnaSud(TipoLinkColonna l){
		if (l!=null && l.getNord() == this){
			ManagerColonna.inserisci(l);
		}
	}
	
	public void inserisciPerManagerColonnaSud(ManagerColonna m){
		if(m!=null){
			sud = m.getLink();
		}
	}

	public void eliminaLinkColonnaNord(TipoLinkColonna l){
		if (l!=null && l.getSud() == this){
			ManagerColonna.elimina(l);
		}
	}
	
	public void eliminaPerManagerColonnaNord(ManagerColonna m){
		if(m!=null){
			nord = null;
		}
	}
	
	public void eliminaLinkColonnaSud(TipoLinkColonna l){
		if (l!=null && l.getNord() == this){
			ManagerColonna.elimina(l);
		}
	}
	
	public void eliminaPerManagerColonnaSud(ManagerColonna m){
		if(m!=null){
			sud = null;
		}
	}

	public void inserisciLinkRigaEst(TipoLinkRiga l){
		if (l!=null && l.getOvest() == this){
			ManagerRiga.inserisci(l);
		}
	}
	
	public void inserisciPerManagerRigaEst(ManagerRiga m){
		if(m!=null){
			est = m.getLink();
		}
	}
	
	public void inserisciLinkRigaOvest(TipoLinkRiga l){
		if (l!=null && l.getEst() == this){
			ManagerRiga.inserisci(l);
		}
	}
	
	public void inserisciPerManagerRigaOvest(ManagerRiga m){
		if(m!=null){
			ovest = m.getLink();
		}
	}

	public void eliminaLinkRigaEst(TipoLinkRiga l){
		if (l!=null && l.getOvest() == this){
			ManagerRiga.elimina(l);
		}
	}
	
	public void eliminaPerManagerRigaEst(ManagerRiga m){
		if(m!=null){
			est = null;
		}
	}
	
	public void eliminaLinkRigaOvest(TipoLinkRiga l){
		if (l!=null && l.getEst() == this){
			ManagerRiga.elimina(l);
		}
	}
	
	public void eliminaPerManagerRigaOvest(ManagerRiga m){
		if(m!=null){
			ovest = null;
		}
	}
	
	// gestione stato

	public enum Stato {
		NON_ATTIVA, POPOLATA, DESERTA
	}

	Stato statoCorrente = Stato.NON_ATTIVA; // nota visibilita' package

	public Stato getStato() {
		return statoCorrente;
	}

	public void fired(Evento e) {
		Executor.perform(new ColoniaFired(this, e, finestraRegione));
	}
	
	public void inizializza(Stato s){
		if(inizializzata)
			return;
		statoCorrente = s;
		inizializzata = true;
	}
}








