package gui;

import _framework.*;
import lega.*;
import lega.squadra.*;
import java.util.*;

import javax.swing.*;

import gui.attivita.atomiche.*;

public class AttivitaIO {
	private static HashSet<TipoLinkPartita> partite = new HashSet<TipoLinkPartita>();
	
	public static TipoLinkPartita LeggiPartita(){
		// Task LeggiPartita
		EstraiInformazioniPartite estraiInfo = new EstraiInformazioniPartite((Set<TipoLinkPartita>)partite.clone());
		synchronized(partite){
			// Esegue un task per la lettura delle informazioni (squadre, risultato) associate alle partite
			Executor.perform(estraiInfo);
		}
		FinestraLeggiPartita f = new FinestraLeggiPartita(estraiInfo.getRisultato());
		TipoLinkPartita risultato = f.attendiSelezione(); // variabile risultato necessaria per chiudere la finestra
		f.dispose();// chiude la finestra
		return risultato;
	}
	
	public static Squadra qualeSquadra(TipoLinkPartita partita){
		// Task QualeSquadra
		// Imposta vettore di Object contenente le stringhe con le opzioni che si vogliono visualizzare
		Object[] options = {"In casa", "In trasferta"};
		
		// Visualizza la finestra (OptionDialog) e memorizza in n l'opzione selezionata dall'utente
		Object quale = JOptionPane.showInputDialog(
				null, // frame padre della finestra 
				"Quale squadra vuoi processare?",// messaggio per l'utente
				"Selezione squadra", // titolo della finestra
			    JOptionPane.QUESTION_MESSAGE, // tipo di messaggio (in questo caso una domanda)
			    null, // icona da visualizzare 
			    options, // array delle opzioni
			    options[0] // opzione di default
        );
		if (quale == options[0]){
			return partita.getCasa();
		}
		else{
			return partita.getTrasferta();
		}
	}
	
	public static boolean altraSquadra(){
		// Task AltraSquadra
		int n = JOptionPane.showConfirmDialog(
			    null,
			    "Vuoi procedere con l'altra squadra?",
			    "",
			    JOptionPane.YES_NO_OPTION);
		if (n==JOptionPane.YES_OPTION){
			return true;
		}
		return false;
	}
	
	public static void stampaHTML(int vinteCasa, int vinteTrasferta, float mediaEtaCasa, float mediaEtaTrasferta){
		// Task StampaHTML
		System.out.print("La squadra di casa ");
		if(mediaEtaCasa > -1){
			System.out.print("ha un'eta' media di: " + mediaEtaCasa + " anni ed ");
		}
		System.out.println("ha vinto: " + vinteCasa + " partite");
		System.out.print("La squadra in trasferta ");
		if(mediaEtaTrasferta > -1){
			System.out.print("ha un'eta' media di: " + mediaEtaTrasferta + " anni ed ");
		}
		System.out.println("ha vinto: " + vinteTrasferta + " partite");
	}
	
	// Meotodi aggiuntivi
	public static void inserisciPartita(TipoLinkPartita partita){
		// Permette ai clienti esterni di comunicare ad AttivitaIO quali sono le nuove partite create
		synchronized(partite){
			partite.add(partita);
		}
	}		
}


