package applicazione;

import gui.AttivitaIO;
import attivita.complesse.*;
import lega.*;
import lega.giocatore.*;
import lega.squadra.*;
import lega.neopromossa.*;
import java.util.*;

public class Main {
	
	public static void main(String[] args){
		inizializzaDati();
		
		Thread t = new Thread(new AttivitaPrincipale());
		t.start();
		try{
			t.join();// attende il completamento dell'attivita' principale
		}
		catch(InterruptedException e){
			e.printStackTrace();
			System.exit(1);
		}
	}
	
	private static void inizializzaDati(){
		// Inizializzazione del diagramma UML con dati di test
		
		Squadra verdi = new Squadra("Verdi");
		Squadra rossi = new Squadra("Rossi");
		Squadra gialli = new Squadra("Gialli");
		Squadra blu = new Squadra("Blu");

		try{
			TipoLinkPartita p = new TipoLinkPartita(verdi, 2, rossi, 0);
			verdi.inserisciLinkPartita(p);
			AttivitaIO.inserisciPartita(p);
			
			p=new TipoLinkPartita(verdi, 3, blu, 1);
			verdi.inserisciLinkPartita(p);
			AttivitaIO.inserisciPartita(p);
			
			p=new TipoLinkPartita(blu, 2, rossi, 0);
			blu.inserisciLinkPartita(p);
			AttivitaIO.inserisciPartita(p);
			
			p=new TipoLinkPartita(gialli, 1, rossi, 3);
			rossi.inserisciLinkPartita(p);
			AttivitaIO.inserisciPartita(p);
			
		}
		catch (EccezionePrecondizioni e){
			e.printStackTrace();
		}
		
		// Crea ed aggiunge giocatori alle squadre
		// et casuale tra 1970 e 1980
		// (Math.random() resituisce un double casuale tra 0.0 e 1.0)
		for (int i = 0; i< 20; i++){
			Giocatore g = new Giocatore("verde-"+i,1970 + (int) (10*Math.random()));
			verdi.insericiLinkGioca(g);
			
			g = new Giocatore("rosso-"+i,1970 + (int) (10*Math.random()));
			rossi.insericiLinkGioca(g);
			
			g = new Giocatore("giallo-"+i,1970 + (int) (10*Math.random()));
			gialli.insericiLinkGioca(g);

			g = new Giocatore("blu-"+i,1970 + (int) (10*Math.random()));
			blu.insericiLinkGioca(g);
		}
	}
}
