package app.gui.display;
import java.awt.event.*;
import javax.swing.*;

class Listener implements ActionListener
{
  private Display frame;
  public final static String MOSTRABTN = "Mostra";
  public final static String CANCELLABTN = "Cancella";
  private String InsText=""; 

  public Listener(Display aFrame)
  {
    frame=aFrame;
  }
  
  public void actionPerformed(ActionEvent e)
  {
    if (e.getActionCommand().equals(MOSTRABTN))
    {
      frame.DigitCodeText.setText(InsText);
    }
    else if (e.getActionCommand().equals(CANCELLABTN))
    {
      int yn = JOptionPane.showConfirmDialog(frame,"Cancellare il testo digitato?",frame.getTitle(),JOptionPane.YES_NO_OPTION,JOptionPane.QUESTION_MESSAGE);
      if (yn == JOptionPane.YES_OPTION)
      {
        InsText = "";
        frame.DigitCodeText.setText("");
        frame.PasswordText.setText("");
      }
    }
    else
    {
      try
      {
        Integer.parseInt(e.getActionCommand());
      }
      catch(NumberFormatException err)
      {
        throw(new IllegalArgumentException());
      }
      InsText = InsText + e.getActionCommand();
      frame.PasswordText.setText(InsText);
    }

  }
}