package venditore;

public class TipoLinkComprende
{
	private final Alimento alimento;
	private final Ordine ordine;
	private final int quantita;
	
	public TipoLinkComprende(Alimento alimento, Ordine ordine, int quantita) throws EccezionePrecondizioni
	{
		if (alimento==null || ordine==null)
			throw(new EccezionePrecondizioni("Impossibile passare dei valori nulli"));
		if (quantita<=0)
			throw(new EccezionePrecondizioni("La quantit� deve essere un valore positivo"));			
		this.alimento=alimento;
		this.ordine=ordine;
		this.quantita=quantita;
	}
	
	public Alimento getAlimento() {
		return alimento;
	}


	public int hashCode() 
	{
		return alimento.hashCode()+ordine.hashCode();
	}
	
	public int getQuantita()
	{
		return quantita;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		TipoLinkComprende other = (TipoLinkComprende) obj;
		if (!alimento.equals(other.alimento))
			return false;
		if (!ordine.equals(other.ordine))
			return false;
		return true;
	}

	public Ordine getOrdine() {
		return ordine;
	}

}
