package venditore;

import java.util.*;

public class Ordine 
{
	private static int numeroMax=0;
	
	private final int numero;
	private final Date dataApertura;
	private Date dataInvioOrdine=null;
	private final HashSet<TipoLinkComprende> insiemeAlimenti=new HashSet<TipoLinkComprende>();
	
	public Ordine()
	{
		numero=(++numeroMax);
		dataApertura=new Date();
	}

	public int getNumero() 
	{
		return numero;
	}

	public Date getDataApertura() 
	{
		return dataApertura;
	}
	
	public void setDataInvioOrdine(Date data)
	{
		dataInvioOrdine=data;
	}
	
	public Date getDataInvioOrdine()
	{
		return dataInvioOrdine;
	}
	

	public void inserisciLinkComprende(TipoLinkComprende t) 
	{
		if (t != null && t.getOrdine() == this)
			ManagerComprende.inserisci(t);
	}
	
	public void inserisciLinkPerManagerComprende(ManagerComprende k)
	{
		if (k!=null)
			insiemeAlimenti.add(k.getLink());
	}

	public void eliminaLinkComprende(TipoLinkComprende t) {
		if (t != null && t.getOrdine() == this)
			ManagerComprende.elimina(t);
	}

	public void eliminaLinkPerManagerComprende(ManagerComprende k)
	{
		if (k!=null)
			insiemeAlimenti.remove(k.getLink());
	}
	
	
	@SuppressWarnings("unchecked")
	public Set<TipoLinkComprende> getLinkComprende()
	{
		return (Set<TipoLinkComprende>) insiemeAlimenti.clone();
	}
	
}
