package processo;


import java.util.HashSet;
import java.util.Iterator;

import venditore.Alimento;
import venditore.Ordine;
import venditore.TipoLinkComprende;

import _framework.Executor;
import _framework.Task;

public class CalcolaQuantitaETotale implements Task 
{
	Ordine corrente;
	float totale=0;
	HashSet<RecordAlimento> lista=new HashSet<RecordAlimento>();
	boolean eseguita=false;
	
	public CalcolaQuantitaETotale(Ordine corrente) 
	{
		this.corrente=corrente;
	}

	public synchronized void esegui(Executor e) 
	{
		if (eseguita)
			return;
		eseguita=true;
		Iterator<TipoLinkComprende> iter=corrente.getLinkComprende().iterator();
		while(iter.hasNext())
		{
			TipoLinkComprende link=iter.next();
			RecordAlimento elem=new RecordAlimento(link.getAlimento(),link.getQuantita());
			lista.add(elem);
			totale+=elem.getQuantita()*elem.getAlimento().getPrezzo();		
		}
	}

	public float getTotale() {

		return totale;
	}

	public HashSet<RecordAlimento> getAlimenti() {
		// TODO Auto-generated method stub
		return lista;
	}

}
