package processo;

import venditore.*;
import _framework.*;
import gui.*;


public class AttivitaSottoramoCibo implements Runnable {
	private boolean eseguita=false;
	private Ordine corrente=null;
	private boolean ancoraCibo=true;
	private RecordAlimento ciboSelezionato;
	
	public AttivitaSottoramoCibo(Ordine ordineCorrente, boolean b){
		this.corrente=ordineCorrente;
		this.ancoraCibo=b;
	}
		
	public synchronized void run() 
	{
		if (eseguita)
			return;
		eseguita = true;
		
		while(ancoraCibo){		
			ciboSelezionato = AttivitaIO.selezionareCibo();
			
			AggiornareOrdine aggiornaScontrino = new AggiornareOrdine(ciboSelezionato.getAlimento(), ciboSelezionato.getQuantita(),
					corrente);
			Executor.perform(aggiornaScontrino);
			
			ancoraCibo = AttivitaIO.chiedereSeAltroCibo();
		}
	}	
}
