package processo;

import java.util.*;

import venditore.*;
import _framework.*;
import gui.*;


public class AggiornareOrdine implements Task {
	private boolean eseguita=false;
	private Ordine corrente;
	private Alimento alimento;
	private int quantita;

	public AggiornareOrdine(Alimento alimento, int quantita, Ordine corrente){
		this.corrente = corrente;
		this.alimento=alimento;
		this.quantita=quantita;
	}

	public synchronized void esegui(Executor e) {
		if (eseguita || e==null)
			return;
		eseguita = true;
		try{
			TipoLinkComprende nuovoLink = new TipoLinkComprende(alimento, corrente, quantita);

			// Se e' gia' presente un link comprende tra scontrinoCorrente ed alimentoAcquistato, deve essere rimpiazzato da un link analogo
			// con quantita' pari a quella del link presente pi� la quantita' di alimento acquistata
			// NOTA: Per rimpiazzare il link con uno nuovo, occorre eliminare il precedente ed inserire il nuovo
			if (corrente.getLinkComprende().contains(nuovoLink)){
				Iterator<TipoLinkComprende> linkIt = corrente.getLinkComprende().iterator();
				TipoLinkComprende linkPresente=null;
				// Scorre l'insieme dei link fino a trovare il link gia' presente uguale a quello da inserire 
				// NOTA: le quantita' non sono rilevanti per equals()
				do{
					
					linkPresente = linkIt.next();
				}
				while(!linkPresente.equals(nuovoLink));

				//Rimpiazza il link gia' presente con quello nuovo
				corrente.eliminaLinkComprende(linkPresente);
				corrente.inserisciLinkComprende(new TipoLinkComprende(alimento, corrente, quantita+linkPresente.getQuantita()));
			}
			else{
				//Viceversa, se non esiste alcun link, allora si inserisce il nuovo link
				corrente.inserisciLinkComprende(nuovoLink);
			}
		}
		catch(EccezionePrecondizioni ecc){
			ecc.printStackTrace();
			System.exit(1);
		}
	}
}



