package gui;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.util.*;

import javax.swing.*;

import processo.RecordAlimento;
import venditore.Alimento;


public class VisioneOrdine extends JFrame 
{
	private JLabel numeroLbl=new JLabel("Numero ordine: ");
	private JLabel dataAperturaLbl=new JLabel("Data apertura: ");
	private JLabel dataInvioLbl=new JLabel("Data prevista invio:");
	private JLabel totaleLbl=new JLabel("Totale: ");
	private JPanel okPnl=new JPanel();
	private JButton okBtn=new JButton("Conferma Ordine");
	private JButton modOrdBtn=new JButton("Modifica Ordine");
	private static final String intestazione[]={"Alimento","Quantita'"};
	private JPanel centroPnl=new JPanel();
	private VisioneOrdineListener ascoltatore=new VisioneOrdineListener(this);
	public boolean ordconfermato=true;
	
	private String[][] creaTabella(Set<RecordAlimento> insieme)
	{
		Iterator<RecordAlimento> iter=insieme.iterator();
		String[][] retValue=new String[insieme.size()][2];
		int i=0;
		while(iter.hasNext())
		{
			RecordAlimento elem=iter.next();
			retValue[i][0]=elem.getAlimento().getNome();
			retValue[i][1]=elem.getQuantita()+"";
			i++;
		}
		return(retValue);
	}
	
	public VisioneOrdine(int numOrdine,Date apertura,Date invio, float totale, HashSet<RecordAlimento> al, boolean modOrdBtnOn) 
	{
		super("Ordine");
		numeroLbl.setText(numeroLbl.getText()+numOrdine);
		dataAperturaLbl.setText(dataAperturaLbl.getText()+apertura);

			
		totaleLbl.setText(totaleLbl.getText()+totale);
		centroPnl.add(numeroLbl);
		centroPnl.add(dataAperturaLbl);
		if(invio!=null)
		{
			dataInvioLbl.setText(dataInvioLbl.getText()+invio);
			centroPnl.add(dataInvioLbl);
		}		
		String[][] tab=creaTabella(al);
		centroPnl.add(new JScrollPane(new JTable(tab,intestazione)));
		centroPnl.add(totaleLbl);
		getContentPane().add(centroPnl,BorderLayout.CENTER);
		okPnl.add(okBtn);
		okBtn.addActionListener(ascoltatore);
		okBtn.setActionCommand(VisioneOrdineListener.OK);
		if (modOrdBtnOn)
			okPnl.add(modOrdBtn);
		else
			okBtn.setText("OK");
		modOrdBtn.addActionListener(ascoltatore);
		modOrdBtn.setActionCommand(VisioneOrdineListener.CANC);
		getContentPane().add(okPnl,BorderLayout.SOUTH);
		setSize(480,570);
		setVisible(true);
	}

}
