package gui;

import java.awt.event.*;
import java.util.*;
import javax.swing.*;

import applicazione.Main;
import processo.*;
import venditore.*;

public class FinestraPrincipaleListener implements ActionListener {

	public static final String NUOVOACQUISTO = "N";
	public static final String STATISTICHE = "S";

	public void actionPerformed(ActionEvent arg0) 
	{
		String com=arg0.getActionCommand();
		if (com==NUOVOACQUISTO)
			nuovoAcquisto();
		else if (com==STATISTICHE)
			statistiche();	
	}

	private void statistiche() 
	{
		try {
			//Unisci l'array delle bevande e quello dei cibi
			Alimento[] array = new Alimento[Main.bevande.length+Main.cibi.length];
			System.arraycopy(Main.bevande, 0, array, 0,  Main.bevande.length);
			System.arraycopy(Main.cibi, 0, array, Main.bevande.length, Main.cibi.length);
			if (array.length == 0)
			{
				JOptionPane.showMessageDialog(null,"Nessun alimento in archivio");
				return;
			}
			Alimento a = (Alimento) JOptionPane.showInputDialog(null,
					"Selezionare un alimento", "Statistiche alimento",
					JOptionPane.INFORMATION_MESSAGE, null, array, array[0]);
			if (a==null)
				return;
			int quant = OperazioniUtente.getQuantitaVendute(a);
			JOptionPane.showMessageDialog(null, "L'alimento " + a.getNome()
					+ " e` stato venduto in quantita': " + quant);
		} catch (EccezioneCardMinMax e) 
		{
			e.printStackTrace();
		}
	}

	private void nuovoAcquisto() 
	{
		AttivitaPrincipale attivitaPrincipale = new AttivitaPrincipale();
		Thread t = new Thread(attivitaPrincipale);
		t.start();
	}

}
