package venditore;

import java.util.*;

public abstract class Alimento 
{
	private final String nome;
	private final float prezzo;
	private HashSet<TipoLinkComprende> insieme=new HashSet<TipoLinkComprende>();
	
	public Alimento(String nome,float prezzo) throws EccezionePrecondizioni
	{
		this.nome=nome;
		if (prezzo>0)
			this.prezzo = prezzo;
		else
			throw(new EccezionePrecondizioni("Il prezzo deve essere maggiore di 0"));		
	}
	
	public float getPrezzo() {
		return prezzo;
	}

	public String getNome() {
		return nome;
	}

	public void inserisciLinkComprende(TipoLinkComprende t) {
		if (t != null && t.getAlimento() == this)
			ManagerComprende.inserisci(t);
	}
	
	public void inserisciLinkPerManagerComprende(ManagerComprende k) 
	{
		//DA COMPLETARE A CURA DELLO STUDENTE
	}
	
	public void eliminaLinkComprende(TipoLinkComprende t) {
		if (t != null && t.getAlimento() == this)
			ManagerComprende.elimina(t);
	}
	
	public void eliminaLinkPerManagerComprende(ManagerComprende k) 
	{
		if (k!=null)
			insieme.remove(k.getLink());
	}
	
	
	@SuppressWarnings("unchecked")
	public Set<TipoLinkComprende> getLinkComprende()
	{
		return((Set<TipoLinkComprende>)insieme.clone());
	}
	
	public String toString(){
		return nome;
	}
}
