package processo;

import java.util.Date;
import java.util.HashSet;

import venditore.*;

import gui.*;
import _framework.*;

public class AttivitaPrincipale implements Runnable 
{
	private boolean eseguita=false;
	private Ordine corrente=null;
	private RecordTipoAcquisti tipoAcquisti=null;
	private boolean ordConfermato=false;
	private HashSet<RecordAlimento> alimenti=null;
	private float totale=0;

	public synchronized void run() {
		if (eseguita)
			return;
		eseguita = true;
		tipoAcquisti=AttivitaIO.chiedereTipoAlimenti();

		if (!tipoAcquisti.isBevanda() && !tipoAcquisti.isCibo())
			return;

		//DA COMPLETARE A CURA DELLO STUDENTE
		
	do
	{
		Thread sottoRamoCibo = new Thread(new AttivitaSottoramoCibo(corrente,tipoAcquisti.isCibo()));;
		Thread sottoRamoBevande = new Thread(new AttivitaSottoramoBevande(corrente,tipoAcquisti.isBevanda()));


		sottoRamoCibo.start();


		sottoRamoBevande.start();



		//join
		try
		{
			sottoRamoCibo.join();
			sottoRamoBevande.join();
		}
		catch (InterruptedException e){
			e.printStackTrace();
			System.exit(1);
		}	

		//DA COMPLETARE A CURA DELLO STUDENTE
	} while(ordConfermato==false);

	PrepararePerInvio invio=new PrepararePerInvio(corrente);
	Executor.perform(invio);
	AttivitaIO.mostrareOrdine(corrente.getNumero(),corrente.getDataApertura(),corrente.getDataInvioOrdine(),totale, alimenti);
}
}

