package gui;

import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.GridLayout;
import java.util.*;

import javax.swing.*;

import processo.RecordAlimento;
import venditore.Alimento;
import venditore.Cibo;


public class SelezionaAlimento extends JFrame 
{
	private final JComboBox alimentiCbx;
	private final JLabel alimentiLbl=new JLabel("Alimenti:");
	private final JPanel alimentiPnl=new JPanel();
	private final JLabel quantitaLbl=new JLabel("Quantita':");
	final JTextField quantitaTxt=new JTextField(2);
	private final JButton okBtn = new JButton("OK");
	private final JPanel centroPnl=new JPanel(new GridLayout(2,1));
	private final JPanel quantitaPnl=new JPanel();
	private final JPanel sudPnl=new JPanel();
	
	public SelezionaAlimento(Vector<Alimento> e)
	{
		super("Seleziona Alimento");
		alimentiCbx=new JComboBox(e);
		alimentiPnl.add(alimentiLbl);
		alimentiPnl.add(alimentiCbx);
		centroPnl.add(alimentiPnl);
		quantitaPnl.add(quantitaLbl);
		quantitaPnl.add(quantitaTxt);
		centroPnl.add(quantitaPnl);
		sudPnl.add(okBtn);
		okBtn.addActionListener(new SelezionaAlimentoListener(this));
		getContentPane().add(centroPnl,BorderLayout.CENTER);
		getContentPane().add(sudPnl,BorderLayout.SOUTH);
		setSize(200,250);
		setVisible(true);
		setResizable(true);
	}
	
	public RecordAlimento getRecord() throws NumberFormatException
	{
		Alimento alim = (Alimento) alimentiCbx.getSelectedItem();
		return (new RecordAlimento(alim, Integer.parseInt(quantitaTxt.getText())));

	}

}
