package gui;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.Vector;

import javax.swing.JOptionPane;

import processo.RecordAlimento;
import processo.RecordTipoAcquisti;
import venditore.Alimento;
import venditore.Bevanda;
import venditore.Cibo;


import applicazione.Main;

public class AttivitaIO 
{
	public static RecordTipoAcquisti chiedereTipoAlimenti()
	{
		boolean bevande=false;
		boolean cibi=false;
		String[] scelte={"Cibi","Bevande","Cibi e Bevande"};
		String scelta=
			(String) JOptionPane.showInputDialog(null,"Che cosa si desidera comprare?","Ordine",JOptionPane.QUESTION_MESSAGE,null,scelte,scelte[0]);
		if (scelta!=null)
		{
			bevande=scelta.contains("Bevande");
			cibi=scelta.contains("Cibi");
		}
		else
			return null;
		return(new RecordTipoAcquisti(cibi,bevande));
	}
	
	public static RecordAlimento selezionareCibo()
	{
		Vector<Alimento> cibi=new Vector<Alimento>();
		for (Cibo x : Main.cibi)
			cibi.add(x);
		SelezionaAlimento alim=new SelezionaAlimento(cibi);
		synchronized (alim) 
		{
			try {
				alim.wait();
			} catch (InterruptedException e) {
				e.printStackTrace();
				return(null);
			}
		}
		alim.setVisible(false);
		return(alim.getRecord());
	}
	
	public static RecordAlimento selezionareBevanda() 
	{
		Vector<Alimento> bevande=new Vector<Alimento>();
		for (Bevanda x : Main.bevande)
			bevande.add(x);
		SelezionaAlimento alim=new SelezionaAlimento(bevande);
		synchronized (alim) 
		{
			try {
				alim.wait();
			} catch (InterruptedException e) {
				e.printStackTrace();
				return(null);
			}
		}
		alim.setVisible(false);
		return(alim.getRecord());
	}
	
	public static boolean chiedereSeAltroCibo()
	{
		int yn=JOptionPane.showConfirmDialog
		(null, "Si desidera comprare altro cibo?","Ordine",JOptionPane.YES_NO_OPTION);
		return(yn==JOptionPane.YES_OPTION);
	}
	
	public static boolean chiedereSeAltraBevanda()
	{
		int yn=JOptionPane.showConfirmDialog
		(null, "Si desidera comprare un'altra bevanda?","Ordine",JOptionPane.YES_NO_OPTION);
		return(yn==JOptionPane.YES_OPTION);
	}	

	public static boolean confermareOrdine(int numOrdine,Date apertura,float totale, HashSet<RecordAlimento> al)
	{
		VisioneOrdine frame=new VisioneOrdine(numOrdine,apertura,null,totale, al, true);
		synchronized (frame) 
		{
			try {
				frame.wait();
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
		return(frame.ordconfermato);
	}	
	
	public static void mostrareOrdine(int numOrdine,Date apertura,Date invio,float totale, HashSet<RecordAlimento> al)
	{
		VisioneOrdine frame=new VisioneOrdine(numOrdine,apertura,invio,totale, al, false);
		synchronized (frame) 
		{
			try {
				frame.wait();
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
	}
}
