package soldato;

import _framework.*;
import _gestioneeventi.*;
import partecipa.*;


public class Soldato implements Listener {
	private final String nome;
	private final String cognome;
	private final int matricola;
	
	private TipoLinkPartecipa linkPartecipa = null;
	
	// Gestione proprieta'
	
	public Soldato(String nome, String cognome, int matricola) {
		this.nome = nome;
		this.cognome = cognome; 
		this.matricola = matricola; 
	}

	public String getNome() {
		return nome;
	}

	public String getCognome() {
		return cognome;
	}
	
	public int getMatricola() {
		return matricola;
	}
	
	//Gestione associazioni
	
	TipoLinkPartecipa getLinkPartecipa(){
		return linkPartecipa;
	}
	
	public int quantiPartecipa(){
		if (linkPartecipa == null)
			return 0;
		return 1;
	}
	
	public void inserisciLinkPartecipa(TipoLinkPartecipa link) {
		if (link != null && link.getSoldato() == this)
			ManagerPartecipa.inserisci(link);
	}

	public void eliminaLinkPartecipa(TipoLinkPartecipa link) {
		if (link != null && link.getSoldato() == this)
			ManagerPartecipa.elimina(link);
	}

	public void inserisciPerManagerPartecipa(ManagerPartecipa k) {
		if (k != null)
			linkPartecipa = k.getLink();
	}

	public void eliminaPerManagerPartecipa(ManagerPartecipa k) {
		if (k != null)
			linkPartecipa = null;
	}

	
	// Gestione stato

	public static enum Stato {
		INNOCENTE, COLPEVOLE, SCOPERTO, FINITA
	}

	Stato statocorrente = Stato.INNOCENTE;

	public Stato getStato() {
		return statocorrente;
	}

	public void fired(Evento e) {
		Executor.perform(new SoldatoFired(this, e));
	}
	
	// Output

	public String toString() {
		return nome + " " + cognome + " (" + matricola + ")";
	}
}
