package partecipa;

import partita.*;
import soldato.*;

public class TipoLinkPartecipa {
	private final Soldato soldato;
	private final Partita partita;

	public TipoLinkPartecipa(Soldato soldato, Partita partita) {
		if (soldato == null || partita == null) // CONTROLLO PRECONDIZIONI
			throw new RuntimeException("Gli oggetti devono essere inizializzati");
		this.soldato = soldato;
		this.partita = partita;
	}

	public boolean equals(Object o) {
		if (o != null && getClass().equals(o.getClass())) {
			TipoLinkPartecipa b = (TipoLinkPartecipa) o;
			return b.soldato == soldato && b.partita == partita;
		} else
			return false;
	}

	public int hashCode() {
		return partita.hashCode() + soldato.hashCode();
	}

	public Partita getPartita() {
		return partita;
	}

	public Soldato getSoldato() {
		return soldato;
	}
}
