package partecipa;

public final class ManagerPartecipa {

	private TipoLinkPartecipa link;

	private ManagerPartecipa(TipoLinkPartecipa link) {
		this.link = link;
	}

	public TipoLinkPartecipa getLink() {
		return link;
	}

	public static void inserisci(TipoLinkPartecipa link) {
		if (link != null && link.getSoldato().quantiPartecipa() == 0) {
			ManagerPartecipa k = new ManagerPartecipa(link);
			link.getSoldato().inserisciPerManagerPartecipa(k);
			link.getPartita().inserisciPerManagerPartecipa(k);
		}
	}

	public static void elimina(TipoLinkPartecipa link) {
		if (link != null) {
			ManagerPartecipa k = new ManagerPartecipa(link);
			link.getSoldato().eliminaPerManagerPartecipa(k);
			link.getPartita().eliminaPerManagerPartecipa(k);
		}
	}
}
