package attivita_composte;

import soldato.*;
import partita.*;

import attivita_io.*;
import attivita_atomiche.*;

import _framework.*;
import _gestioneeventi.*;

public class AttivitaPrincipale implements Runnable {

	private boolean eseguita = false;
	
	private boolean altroSoldato = true;
	private boolean voltatoPresente = false;
	private int numSoldati = 0;
	private Partita partitaCorrente = null;
	private Soldato soldatoCorrente = null;
	private boolean soldatoCorrenteVoltato = false;

	public synchronized void run() {
		if (eseguita == true)
			return;
		eseguita = true;
		
		partitaCorrente = AttivitaIO.leggiPartita();
		
		while(altroSoldato){
			soldatoCorrenteVoltato = false;
			soldatoCorrente = AttivitaIO.leggiSoldato();
			if(!voltatoPresente){
				soldatoCorrenteVoltato = AttivitaIO.chiediSeVoltato();
				if (soldatoCorrenteVoltato){
					voltatoPresente = true;
				}
			}
			
			AggiungiAPartita aggiungiAPartita = new AggiungiAPartita(partitaCorrente, soldatoCorrente, soldatoCorrenteVoltato);
			Executor.perform(aggiungiAPartita);
			
			numSoldati++;
			if(numSoldati >= 3 && voltatoPresente){
				altroSoldato = AttivitaIO.chiediSeAltroSoldato();
			}
		}
		
		// Avvia la partita
		AvviaPartita avviaPartita = new AvviaPartita(partitaCorrente);
		Executor.perform(avviaPartita);
		
		
		AttendiTerminePartita attendiTerminePartita = new AttendiTerminePartita(partitaCorrente);
		do{
			try {
				// Diamo alla partita il tempo di finire
				Thread.sleep(100);
			}catch (InterruptedException e) {
				e.printStackTrace();
			}
			Executor.perform(attendiTerminePartita);
		}
		while(!attendiTerminePartita.getRisultato());// ripete finche' la partita non e' terminata
		
		// Esecuzione terminata: disattiva i listener
		EsecuzioneEnvironment.disattivaListener();
		
		//Stampa il nome del soldato scoperto
		AttivitaIO.stampaColpevole(partitaCorrente);
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}
	
}
