package attivita_atomiche;

import eventi.*;
import partecipa.*;
import partita.*;
import soldato.*;

import java.util.*;

import _framework.*;
import _gestioneeventi.*;

public class AvviaPartita implements Task {

	private boolean eseguita = false;
	private Partita partita;

	public AvviaPartita(Partita partita) {
		this.partita = partita;
	}

	public synchronized void esegui(Executor e) {

		if (e == null || eseguita == true)
			return;
		eseguita = true;

		Iterator<TipoLinkPartecipa> it = partita.getLinkPartecipa().iterator();
		while (it.hasNext()) {
			Soldato soldato = it.next().getSoldato();
			EsecuzioneEnvironment.addListener(soldato);
		}
		
		Soldato primo = partita.getLinkPartecipa().get(0).getSoldato();// Soldato a cui spetta il primo turno
		if (primo.equals(partita.getVoltato())){
			// Se il priom  voltato allora vinene scelto il successivo
			primo=partita.getLinkPartecipa().get(1).getSoldato();
		}
		// Invia l'evento Turno al primo
		Environment.aggiungiEvento(new Turno(null, primo));
		
		// Attiva i Listener
		EsecuzioneEnvironment.attivaListener();
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}
	
}