package attivita_atomiche;

import partita.*;
import soldato.*;
import partecipa.*;

import _framework.Executor;
import _framework.Task;


public class AggiungiAPartita implements Task {

	private boolean eseguita = false;
	private Partita partita;
	private Soldato soldato;
	private boolean voltato;

	public AggiungiAPartita(Partita partita, Soldato soldato, Boolean voltato) {
		this.partita = partita;
		this.soldato = soldato;
		this.voltato = voltato;
	}

	public synchronized void esegui(Executor e) {

		if (e == null || eseguita == true)
			return;
		eseguita = true;

		partita.inserisciLinkPartecipa(new TipoLinkPartecipa(soldato,partita));
		
		if (voltato){
			partita.inserisciVoltato(soldato);
		}		
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}
}
