package soldato;

import java.util.*;
import eventi.*;
import _framework.*;
import _gestioneeventi.*;
import partecipa.*;
import soldato.Soldato.*;


class SoldatoFired implements Task {
	private boolean eseguita = false;
	private Soldato soldato;
	private Evento evento;
	
	private Evento nuovoEvento = null;
	
	public SoldatoFired(Soldato soldato, Evento evento) {
		this.soldato = soldato;
		this.evento = evento;
	}

	public synchronized void esegui(Executor exec) {
		if (eseguita || exec == null || (evento.getDestinatario() != soldato && evento.getDestinatario() != null))
			return;
		eseguita = true;
		
		//Solo per output
		System.out.print(soldato + ", stato: " + soldato.statocorrente + ", riceve: " + evento.getClass());
		
		switch (soldato.getStato()) {
		case INNOCENTE:
			if (evento.getClass() == Prosegui.class) {
				// Non invia eventi
				// Rimane nello stato corrente
				break;
			}
			if (evento.getClass() == Turno.class) {
				if (toccare()){// Si e' deciso di toccare il soldato voltato
					// DA COMPLETARE
				}
				else{// Passa il turno al prossimo soldato
					// DA COMPLETARE
				}
				break;
			}
			if (evento.getClass() == Accusa.class){
				// DA COMPLETARE
				break;				
			}
			if (evento.getClass() == Tocco.class){
				// Il soldato e' stato toccato
				// Invia l'evento Accusa ad un altro soldato (scelto casualmente)
				nuovoEvento = new Accusa(soldato, soldatoAccusato());

				// Rimane nello stato corrente
				break;
			}
			if (evento.getClass() == Fine.class){
				// Non esegue azioni
				// Entra nello stato Finita
				soldato.statocorrente = Stato.FINITA;
				break;
			}
			
		case COLPEVOLE:
			if (evento.getClass() == Prosegui.class) {
				// E' stato accusato il soldato sbagliato				
				// Invia l'evento Turno al prossimo soldato non voltato
				nuovoEvento = new Turno(soldato, prossimo());
				// Entra nello stato INNOCENTE				
				soldato.statocorrente = Stato.INNOCENTE;
				break;
			}
			if (evento.getClass() == Accusa.class) {
				// DA COMPLETARE				
				break;
			}
		case SCOPERTO:
			// stato finale
			break;
		case FINITA:
			// stato finale
			break;
		default:
			throw new RuntimeException("Stato corrente non riconosciuto.");
		}
		
		if (nuovoEvento != null){
			Environment.aggiungiEvento(nuovoEvento);
			
			// Solo per output
			System.out.print(", invia: " + nuovoEvento.getClass() + " a: " + nuovoEvento.getDestinatario());
		}
		// Solo per output
		System.out.println(", nuovo stato: " + soldato.statocorrente);
	}

	public synchronized boolean estEseguita() {
		return eseguita;
	}
	
	
	// Funzioni ausiliarie (private)
	
	private Boolean  toccare() {
		// Restituisce true o false casualmente, con stessa probabilita':
		// true sse si vuole toccare il soldato
		
		Random r = new Random();
		return r.nextBoolean(); // restituisce un Boolean casuale, con probabailita' uniforme
    }
	
	private Soldato prossimo(){
		//Restituisce il primo soldato non voltato successivo a quello corrente, secondo l'ordine della partita 
		
		List<TipoLinkPartecipa> partecipanti = soldato.getLinkPartecipa().getPartita().getLinkPartecipa();
		
		// avanza di uno rispetto alla posizione del soldato corrente, tornando all'inizio della lista se pos e' l'ultimo elemento
		int pos = (partecipanti.indexOf(soldato.getLinkPartecipa()) + 1) % partecipanti.size(); 
		
		// se il soldato nella posizione ottenuta non e' voltato, allora viene resituito...
		if (!partecipanti.get(pos).getSoldato().equals(soldato.getLinkPartecipa().getPartita().getVoltato())){
			return partecipanti.get(pos).getSoldato();
		}		
		//... altrimenti, si restituisce il successivo
		return partecipanti.get((pos + 1) % partecipanti.size()).getSoldato();
	}
	
	private Soldato soldatoAccusato(){
		// Sceglie casualmente un soldato diverso da quello corrente, con probabailita' uniforme
		
		List<TipoLinkPartecipa> partecipanti = soldato.getLinkPartecipa().getPartita().getLinkPartecipa();
		
		Random r = new Random();
		int i = r.nextInt(partecipanti.size());
		// Se il soldato estratto  quello corrente, allora restituisce il successivo
		if (soldato.equals(partecipanti.get(i).getSoldato())){
			i = (i+1) % partecipanti.size();
		}
		return partecipanti.get(i).getSoldato();
	}
		
}
