package partita;

import java.util.*;
import partecipa.*;
import soldato.*;

public class Partita {
	private final String nome;
	
	private LinkedList<TipoLinkPartecipa> partecipanti;
	private Soldato soldatoVoltato = null;
	
	public final int MIN_PARTECIPA = 3;

	// Gestione proprieta'
	
	public Partita(String nome) {
		this.nome = nome;
		partecipanti = new LinkedList<TipoLinkPartecipa>();
	}

	public String getNome() {
		return nome;
	}
	
	//Gestione associazioni

	// Associazione partecipa
	public void inserisciLinkPartecipa(TipoLinkPartecipa link) {
		if (link != null && link.getPartita() == this)
			ManagerPartecipa.inserisci(link);
	}

	public void eliminaLinkPartecipa(TipoLinkPartecipa link) {
		if (link != null && link.getPartita() == this)
			ManagerPartecipa.elimina(link);
	}

	@SuppressWarnings("unchecked")
	public List<TipoLinkPartecipa> getLinkPartecipa() {
		if (quantiSoldati() < MIN_PARTECIPA)
			throw new RuntimeException("Eccezione Molteplicita'");
		return (LinkedList<TipoLinkPartecipa>) partecipanti.clone();
	}

	public void inserisciPerManagerPartecipa(ManagerPartecipa k) {
		if (k != null && !partecipanti.contains(k.getLink()))
			partecipanti.add(k.getLink());
	}

	public void eliminaPerManagerPartecipa(ManagerPartecipa k) {
		if (k != null)
			partecipanti.remove(k.getLink());
	}

	public int quantiSoldati() {
		return partecipanti.size();
	}
	
	// Associazione voltato
	
	public Soldato getVoltato(){
		// DA COMPLETARE
		return soldatoVoltato;
	}
	
	public void inserisciVoltato(Soldato soldatoVoltato){
		this.soldatoVoltato = soldatoVoltato;
	}
			
	// Output
	
	public String toString() {
		return nome;
	}
}
