package attivita_io;

import partita.*;
import soldato.*;
import partecipa.*;

import javax.swing.*;
import java.util.*;

public class AttivitaIO 
{
	public static Partita leggiPartita() {
		String nomePartita = null;
		do{
			nomePartita = JOptionPane.showInputDialog(null,"Inserisci il nome della partita");
		}
		while (nomePartita==null);
		return new Partita(nomePartita);
	}
	
	
	public static Soldato leggiSoldato() {
		String nomeSoldato = null;
		do{
			nomeSoldato = JOptionPane.showInputDialog(null,"Inserisci il nome del prossimo soldato");
		}
		while(nomeSoldato == null);
		
		String cognomeSoldato = null;
		do{
			cognomeSoldato = JOptionPane.showInputDialog(null,"Inserisci il cognome del prossimo soldato");
		}
		while(nomeSoldato == null);
		
		int matricolaSoldato = 0;
		boolean ok = false;
		do{
			try {
				matricolaSoldato = Integer.parseInt(JOptionPane.showInputDialog(null,"Inserisci la matricola del prossimo soldato"));
				ok = true;
			} catch (NumberFormatException e) {}
		}
		while(!ok);

		return new Soldato(nomeSoldato, cognomeSoldato, matricolaSoldato);
	}
	
	public static boolean chiediSeVoltato() {
		int risultato=JOptionPane.showConfirmDialog(null, "Il soldato appena inserito deve giocare con ruolo voltato?", "", JOptionPane.YES_NO_OPTION);
		return(risultato==JOptionPane.YES_OPTION);
	}
	
	public static boolean chiediSeAltroSoldato() {
		int risultato=JOptionPane.showConfirmDialog(null, "Si vuole aggiungere un altro soldato alla partita?", "", JOptionPane.YES_NO_OPTION);
		return(risultato==JOptionPane.YES_OPTION);
	}
	
	public static void stampaColpevole(Partita p){
		List<TipoLinkPartecipa> partecipanti = p.getLinkPartecipa();
		for (int i = 0; i < partecipanti.size(); i++){
			if (partecipanti.get(i).getSoldato().getStato() == Soldato.Stato.SCOPERTO){
				JOptionPane.showMessageDialog(null, "Il soldato colpevole e': " + partecipanti.get(i).getSoldato());
			}
		}		
	}	
}
